/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqClusterReceiverChannel;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMCAType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDataConversion;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonpersistentMessageSpeed;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSSLClientAuthentication;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

public class CreateWmqClusterReceiverChannelStep
extends BaseWmqStep {
    public WmqClusterReceiverChannel wmqClusterReceiverChannel;

    public CreateWmqClusterReceiverChannelStep(WmqClusterReceiverChannel wmqClusterReceiverChannel, WmqQueueManager wmqQmanager) {
        this.wmqClusterReceiverChannel = wmqClusterReceiverChannel;
        this.wmqQmanager = wmqQmanager;
    }

    protected void init() {
        this.mqCommand = 23;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        int[] list;
        pcfCmd.addParameter(3501, this.wmqClusterReceiverChannel.getChannelName());
        pcfCmd.addParameter(1511, 8);
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getDescription())) {
            pcfCmd.addParameter(3502, this.wmqClusterReceiverChannel.getDescription());
        }
        if (WmqTransmissionProtocolTypes.LU6 == this.wmqClusterReceiverChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 1);
        } else if (WmqTransmissionProtocolTypes.NET_BIOS == this.wmqClusterReceiverChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 3);
        } else if (WmqTransmissionProtocolTypes.SPX == this.wmqClusterReceiverChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 4);
        } else {
            pcfCmd.addParameter(1501, 2);
        }
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getConnectionName())) {
            pcfCmd.addParameter(3506, this.wmqClusterReceiverChannel.getConnectionName());
        }
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getLocalCommunicationAddress())) {
            pcfCmd.addParameter(3520, this.wmqClusterReceiverChannel.getLocalCommunicationAddress());
        }
        if (WmqHeaderCompression.SYSTEM == this.wmqClusterReceiverChannel.getHeaderCompression()) {
            list = new int[]{8};
            pcfCmd.addParameter(1575, list);
        } else {
            list = new int[]{0};
            pcfCmd.addParameter(1575, list);
        }
        pcfCmd.addParameter(1510, this.wmqClusterReceiverChannel.getMaximumMessageLength());
        int[] messageCompressionList = new int[1];
        if (WmqMessageCompression.RLE == this.wmqClusterReceiverChannel.getMessageCompression()) {
            messageCompressionList[0] = 1;
            pcfCmd.addParameter(1576, messageCompressionList);
        } else if (WmqMessageCompression.ZLIBFAST == this.wmqClusterReceiverChannel.getMessageCompression()) {
            messageCompressionList[0] = 2;
            pcfCmd.addParameter(1576, messageCompressionList);
        } else if (WmqMessageCompression.ZLIBHIGH == this.wmqClusterReceiverChannel.getMessageCompression()) {
            messageCompressionList[0] = 4;
            pcfCmd.addParameter(1576, messageCompressionList);
        } else {
            messageCompressionList[0] = 0;
            pcfCmd.addParameter(1576, messageCompressionList);
        }
        if (this.wmqClusterReceiverChannel.getKeepAliveInterval() > -1 && this.wmqClusterReceiverChannel.getKeepAliveInterval() <= 99999) {
            pcfCmd.addParameter(1566, this.wmqClusterReceiverChannel.getKeepAliveInterval());
        }
        if (WmqNonpersistentMessageSpeed.NORMAL == this.wmqClusterReceiverChannel.getNonPersistentMessageSpeed()) {
            pcfCmd.addParameter(1562, 1);
        } else {
            pcfCmd.addParameter(1562, 2);
        }
        pcfCmd.addParameter(1502, this.wmqClusterReceiverChannel.getBatchSize());
        pcfCmd.addParameter(1564, this.wmqClusterReceiverChannel.getBatchInterval());
        pcfCmd.addParameter(1503, this.wmqClusterReceiverChannel.getDisconnectInterval());
        if (WmqDataConversion.CONVERSION == this.wmqClusterReceiverChannel.getDataConversion()) {
            pcfCmd.addParameter(1515, 1);
        } else {
            pcfCmd.addParameter(1515, 0);
        }
        pcfCmd.addParameter(1567, this.wmqClusterReceiverChannel.getBatchHeartBeatInterval());
        if (this.wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
            if (WmqChannelPropertyControl.ALL == this.wmqClusterReceiverChannel.getPropertyControl()) {
                pcfCmd.addParameter(190, 2);
            } else if (WmqChannelPropertyControl.NONE == this.wmqClusterReceiverChannel.getPropertyControl()) {
                pcfCmd.addParameter(190, 1);
            } else {
                pcfCmd.addParameter(190, 0);
            }
        }
        pcfCmd.addParameter(1544, this.wmqClusterReceiverChannel.getMessageRetryCount());
        pcfCmd.addParameter(1545, this.wmqClusterReceiverChannel.getMessageRetryInterval());
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getMessageRetryExitname())) {
            pcfCmd.addParameter(3534, this.wmqClusterReceiverChannel.getMessageRetryExitname());
        }
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getMessageRetryExitUserData())) {
            pcfCmd.addParameter(3535, this.wmqClusterReceiverChannel.getMessageRetryExitUserData());
        }
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getClusterName())) {
            pcfCmd.addParameter(2029, this.wmqClusterReceiverChannel.getClusterName());
        }
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getClusterNamelist())) {
            pcfCmd.addParameter(2030, this.wmqClusterReceiverChannel.getClusterNamelist());
        }
        pcfCmd.addParameter(1565, this.wmqClusterReceiverChannel.getNetworkPriority());
        pcfCmd.addParameter(1577, this.wmqClusterReceiverChannel.getClusterWorkloadChannelRank());
        pcfCmd.addParameter(1578, this.wmqClusterReceiverChannel.getClusterWorkloadChannelPriority());
        pcfCmd.addParameter(1579, this.wmqClusterReceiverChannel.getClusterWorkloadChannelWeight());
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getMcaUserID())) {
            pcfCmd.addParameter(3527, this.wmqClusterReceiverChannel.getMcaUserID());
        }
        if (WmqChannelMCAType.THREAD == this.wmqClusterReceiverChannel.getMcaType()) {
            pcfCmd.addParameter(1517, 2);
        } else {
            pcfCmd.addParameter(1517, 1);
        }
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getSendExit())) {
            String[] sendExitList = StringUtils.split(this.wmqClusterReceiverChannel.getSendExit(), ",");
            pcfCmd.addParameter(3510, sendExitList);
        }
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getSendExitUserData())) {
            String[] sendExitUserDataList = StringUtils.split(this.wmqClusterReceiverChannel.getSendExitUserData(), ",");
            pcfCmd.addParameter(3515, sendExitUserDataList);
        }
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getReceiveExit())) {
            String[] receiveExitList = StringUtils.split(this.wmqClusterReceiverChannel.getReceiveExit(), ",");
            pcfCmd.addParameter(3511, receiveExitList);
        }
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getReceiveExitUserData())) {
            String[] receiveExitUserDataList = StringUtils.split(this.wmqClusterReceiverChannel.getReceiveExitUserData(), ",");
            pcfCmd.addParameter(3516, receiveExitUserDataList);
        }
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getSecurityExit())) {
            pcfCmd.addParameter(3508, this.wmqClusterReceiverChannel.getSecurityExit());
        }
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getSecurityExitUserData())) {
            pcfCmd.addParameter(3513, this.wmqClusterReceiverChannel.getSecurityExitUserData());
        }
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getMessageExitName())) {
            String[] messageExitList = StringUtils.split(this.wmqClusterReceiverChannel.getMessageExitName(), ",");
            pcfCmd.addParameter(3509, messageExitList);
        }
        if (StringUtils.isNotBlank(this.wmqClusterReceiverChannel.getMessageExitUserData())) {
            String[] messageExitUserList = StringUtils.split(this.wmqClusterReceiverChannel.getMessageExitUserData(), ",");
            pcfCmd.addParameter(3514, messageExitUserList);
        }
        pcfCmd.addParameter(1505, this.wmqClusterReceiverChannel.getShortRetryCount());
        pcfCmd.addParameter(1504, this.wmqClusterReceiverChannel.getShortRetryInterval());
        pcfCmd.addParameter(1507, this.wmqClusterReceiverChannel.getLongRetryCount());
        pcfCmd.addParameter(1506, this.wmqClusterReceiverChannel.getLongRetryInterval());
        if (WmqChannelMonitoring.HIGH == this.wmqClusterReceiverChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 65);
        } else if (WmqChannelMonitoring.LOW == this.wmqClusterReceiverChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 17);
        } else if (WmqChannelMonitoring.MEDIUM == this.wmqClusterReceiverChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 33);
        } else if (WmqChannelMonitoring.OFF == this.wmqClusterReceiverChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 0);
        } else {
            pcfCmd.addParameter(122, -3);
        }
        if (WmqChannelStatisticTypes.HIGH == this.wmqClusterReceiverChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 65);
        } else if (WmqChannelStatisticTypes.LOW == this.wmqClusterReceiverChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 17);
        } else if (WmqChannelStatisticTypes.MEDIUM == this.wmqClusterReceiverChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 33);
        } else if (WmqChannelStatisticTypes.OFF == this.wmqClusterReceiverChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 0);
        } else {
            pcfCmd.addParameter(129, -3);
        }
        if (this.wmqClusterReceiverChannel.getSslCipherSpecification() != null) {
            pcfCmd.addParameter(3544, this.wmqClusterReceiverChannel.getSslCipherSpecification().toString());
        }
        if (WmqSSLClientAuthentication.OPTIONAL == this.wmqClusterReceiverChannel.getSslClientAuth()) {
            pcfCmd.addParameter(1568, 1);
        } else {
            pcfCmd.addParameter(1568, 0);
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating ClusterReceiverChannel \"" + this.wmqClusterReceiverChannel.getChannelName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating ClusterReceiverChannel Step";
    }

    protected String getSuccessMessage() {
        return "The ClusterReceiverChannel \"" + this.wmqClusterReceiverChannel.getChannelName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

