/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqAccountingConnOverride;
import com.xebialabs.deployit.plugin.wmq.enums.WmqActivityRecording;
import com.xebialabs.deployit.plugin.wmq.enums.WmqAuthorityEvent;
import com.xebialabs.deployit.plugin.wmq.enums.WmqAutoCLUSSDRMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqAutoCLUSSDRStatistics;
import com.xebialabs.deployit.plugin.wmq.enums.WmqCLWLUseQueueQManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelAutoDefinition;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelAutoDefinitionEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelInitControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoringQManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypesQManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqCommandServerControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqIPAddressVersion;
import com.xebialabs.deployit.plugin.wmq.enums.WmqInhibitEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqLocalEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqLoggerEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMQIAccounting;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMQIStatistics;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPerformanceEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPublishSubscribeMode;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPublishSubscribeSyncPoint;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueAccountingQManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueMonitoringQManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueStatisticsQManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqRemoteEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSSLEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSslFipsRequired;
import com.xebialabs.deployit.plugin.wmq.enums.WmqStartAndStopEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTraceRouteRecording;
import com.xebialabs.deployit.plugin.wmq.enums.WmqUndeliveredNonPersistentInputMessage;
import com.xebialabs.deployit.plugin.wmq.enums.WmqUndeliveredNonPersistentResponse;
import com.xebialabs.deployit.plugin.wmq.utils.MQPluginException;

/**
 * Inqires the {@link WmqQueueManager} and retrieves the QueueManager details.
 */
@SuppressWarnings("serial")
public class InquireWmqQueueManagerStep extends BaseWmqStep {

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_INQUIRE_Q_MGR;

	}

	public InquireWmqQueueManagerStep(WmqQueueManager wmqQmanager) {

		this.wmqQmanager = wmqQmanager;
	}

	public void setPCFMessageParameters(PCFMessage pcfCmd) throws MQPluginException {

		int parameters[] = new int[1];
		parameters[0] = MQConstants.MQIACF_ALL;
		pcfCmd.addParameter(MQConstants.MQIACF_Q_MGR_ATTRS, parameters);

	}

	@Override
	protected void readPCFMessageResponse(StepExecutionContext ctx, PCFMessage pcfMessage) {
		if (pcfMessage != null) {

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_ACCOUNTING_CONN_OVERRIDE) == MQConstants.MQMON_DISABLED) {
				wmqQmanager.setAccountingConnOverride(WmqAccountingConnOverride.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_ACCOUNTING_CONN_OVERRIDE) == MQConstants.MQMON_ENABLED) {
				wmqQmanager.setAccountingConnOverride(WmqAccountingConnOverride.ENABLED);
			}

			wmqQmanager.setAccountingInterval((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_ACCOUNTING_INTERVAL));

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_ACTIVITY_RECORDING) == MQConstants.MQRECORDING_DISABLED) {
				wmqQmanager.setActivityRecording(WmqActivityRecording.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_ACTIVITY_RECORDING) == MQConstants.MQRECORDING_MSG) {
				wmqQmanager.setActivityRecording(WmqActivityRecording.MESSAGE);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_ACTIVITY_RECORDING) == MQConstants.MQRECORDING_Q) {
				wmqQmanager.setActivityRecording(WmqActivityRecording.QUEUE);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_AUTHORITY_EVENT) == MQConstants.MQEVR_DISABLED) {
				wmqQmanager.setAuthorityEvent(WmqAuthorityEvent.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_AUTHORITY_EVENT) == MQConstants.MQEVR_ENABLED) {
				wmqQmanager.setAuthorityEvent(WmqAuthorityEvent.ENABLED);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CHANNEL_AUTO_DEF) == MQConstants.MQCHAD_DISABLED) {
				wmqQmanager.setChannelAutoDefinition(WmqChannelAutoDefinition.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CHANNEL_AUTO_DEF) == MQConstants.MQCHAD_ENABLED) {
				wmqQmanager.setChannelAutoDefinition(WmqChannelAutoDefinition.ENABLED);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CHANNEL_AUTO_DEF_EVENT) == MQConstants.MQEVR_DISABLED) {
				wmqQmanager.setChannelAutoDefinitionEvents(WmqChannelAutoDefinitionEvents.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CHANNEL_AUTO_DEF_EVENT) == MQConstants.MQEVR_ENABLED) {
				wmqQmanager.setChannelAutoDefinitionEvents(WmqChannelAutoDefinitionEvents.ENABLED);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CHANNEL_EVENT) == MQConstants.MQEVR_DISABLED) {
				wmqQmanager.setChannelEvents(WmqChannelEvents.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CHANNEL_EVENT) == MQConstants.MQEVR_ENABLED) {
				wmqQmanager.setChannelEvents(WmqChannelEvents.ENABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CHANNEL_EVENT) == MQConstants.MQEVR_EXCEPTION) {
				wmqQmanager.setChannelEvents(WmqChannelEvents.EXCEPTION);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_CHANNEL) == MQConstants.MQMON_OFF) {
				wmqQmanager.setChannelMonitoring(WmqChannelMonitoringQManager.OFF);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_CHANNEL) == MQConstants.MQMON_NONE) {
				wmqQmanager.setChannelMonitoring(WmqChannelMonitoringQManager.NONE);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_CHANNEL) == MQConstants.MQMON_LOW) {
				wmqQmanager.setChannelMonitoring(WmqChannelMonitoringQManager.LOW);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_CHANNEL) == MQConstants.MQMON_MEDIUM) {
				wmqQmanager.setChannelMonitoring(WmqChannelMonitoringQManager.MEDIUM);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_CHANNEL) == MQConstants.MQMON_HIGH) {
				wmqQmanager.setChannelMonitoring(WmqChannelMonitoringQManager.HIGH);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_STATISTICS_CHANNEL) == MQConstants.MQMON_NONE) {
				wmqQmanager.setChannelStatistics(WmqChannelStatisticTypesQManager.NONE);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_STATISTICS_CHANNEL) == MQConstants.MQMON_OFF) {
				wmqQmanager.setChannelStatistics(WmqChannelStatisticTypesQManager.OFF);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_STATISTICS_CHANNEL) == MQConstants.MQMON_LOW) {
				wmqQmanager.setChannelStatistics(WmqChannelStatisticTypesQManager.LOW);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_STATISTICS_CHANNEL) == MQConstants.MQMON_MEDIUM) {
				wmqQmanager.setChannelStatistics(WmqChannelStatisticTypesQManager.MEDIUM);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_STATISTICS_CHANNEL) == MQConstants.MQMON_HIGH) {
				wmqQmanager.setChannelStatistics(WmqChannelStatisticTypesQManager.HIGH);
			}

			wmqQmanager.setClusterWorkloadData((String) pcfMessage.getParameterValue(MQConstants.MQCA_CLUSTER_WORKLOAD_DATA));

			wmqQmanager.setClusterWorkLoadExit(((String) pcfMessage.getParameterValue(MQConstants.MQCA_CLUSTER_WORKLOAD_EXIT)).trim());

			wmqQmanager.setClusterWorkloadLength((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CLUSTER_WORKLOAD_LENGTH));

			wmqQmanager.setMaxOutBoundClusterChannels((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CLWL_MRU_CHANNELS));

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CLWL_USEQ) == MQConstants.MQCLWL_USEQ_ANY) {
				wmqQmanager.setClwlUseQueue(WmqCLWLUseQueueQManager.ANY);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CLWL_USEQ) == MQConstants.MQCLWL_USEQ_LOCAL) {
				wmqQmanager.setClwlUseQueue(WmqCLWLUseQueueQManager.LOCAL);
			}

			wmqQmanager.setCommandLevel((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_COMMAND_LEVEL));

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CMD_SERVER_CONTROL) == MQConstants.MQSVC_CONTROL_MANUAL) {
				wmqQmanager.setCommandServerControl(WmqCommandServerControl.MANUAL);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CMD_SERVER_CONTROL) == MQConstants.MQSVC_CONTROL_Q_MGR) {
				wmqQmanager.setCommandServerControl(WmqCommandServerControl.QUEUE_MANAGER);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_IP_ADDRESS_VERSION) == MQConstants.MQIPADDR_IPV4) {
				wmqQmanager.setIpAddressVersion(WmqIPAddressVersion.IPV4);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_IP_ADDRESS_VERSION) == MQConstants.MQIPADDR_IPV6) {
				wmqQmanager.setIpAddressVersion(WmqIPAddressVersion.IPV6);
			}

			wmqQmanager.setMaxHandles((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MAX_HANDLES));

			wmqQmanager.setMaxMessageLength((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MAX_MSG_LENGTH));

			wmqQmanager.setMaxPriority((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MAX_PRIORITY));

			if (pcfMessage.getParameterValue(MQConstants.MQIA_MAX_PROPERTIES_LENGTH) != null) {
				wmqQmanager.setMaxPropertiesLength((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MAX_PROPERTIES_LENGTH));
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_ACCOUNTING_MQI) == MQConstants.MQMON_OFF) {
				wmqQmanager.setMqiAccounting(WmqMQIAccounting.OFF);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_ACCOUNTING_MQI) == MQConstants.MQMON_ON) {
				wmqQmanager.setMqiAccounting(WmqMQIAccounting.ON);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_STATISTICS_MQI) == MQConstants.MQMON_OFF) {
				wmqQmanager.setMqiStatistics(WmqMQIStatistics.OFF);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_STATISTICS_MQI) == MQConstants.MQMON_ON) {
				wmqQmanager.setMqiStatistics(WmqMQIStatistics.ON);
			}
			if (pcfMessage.getParameterValue(MQConstants.MQCA_PARENT) != null) {
				wmqQmanager.setParent(((String) pcfMessage.getParameterValue(MQConstants.MQCA_PARENT)).trim());
			}
			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PERFORMANCE_EVENT) == MQConstants.MQEVR_DISABLED) {
				wmqQmanager.setPerformanceEvents(WmqPerformanceEvents.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PERFORMANCE_EVENT) == MQConstants.MQEVR_ENABLED) {
				wmqQmanager.setPerformanceEvents(WmqPerformanceEvents.ENABLED);
			}

			wmqQmanager.setPlatform((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PLATFORM));

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_ACCOUNTING_Q) == MQConstants.MQMON_OFF) {
				wmqQmanager.setQueueAccounting(WmqQueueAccountingQManager.OFF);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_ACCOUNTING_Q) == MQConstants.MQMON_NONE) {
				wmqQmanager.setQueueAccounting(WmqQueueAccountingQManager.NONE);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_ACCOUNTING_Q) == MQConstants.MQMON_ON) {
				wmqQmanager.setQueueAccounting(WmqQueueAccountingQManager.ON);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_Q) == MQConstants.MQMON_OFF) {
				wmqQmanager.setQueueMonitoring(WmqQueueMonitoringQManager.OFF);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_Q) == MQConstants.MQMON_NONE) {
				wmqQmanager.setQueueMonitoring(WmqQueueMonitoringQManager.NONE);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_Q) == MQConstants.MQMON_LOW) {
				wmqQmanager.setQueueMonitoring(WmqQueueMonitoringQManager.LOW);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_Q) == MQConstants.MQMON_MEDIUM) {
				wmqQmanager.setQueueMonitoring(WmqQueueMonitoringQManager.MEDIUM);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_Q) == MQConstants.MQMON_HIGH) {
				wmqQmanager.setQueueMonitoring(WmqQueueMonitoringQManager.HIGH);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_Q) == MQConstants.MQMON_OFF) {
				wmqQmanager.setQueueStatistics(WmqQueueStatisticsQManager.OFF);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_Q) == MQConstants.MQMON_ON) {
				wmqQmanager.setQueueStatistics(WmqQueueStatisticsQManager.ON);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_Q) == MQConstants.MQMON_NONE) {
				wmqQmanager.setQueueStatistics(WmqQueueStatisticsQManager.NONE);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_SSL_EVENT) == MQConstants.MQEVR_DISABLED) {
				wmqQmanager.setSslEvents(WmqSSLEvents.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_SSL_EVENT) == MQConstants.MQEVR_ENABLED) {
				wmqQmanager.setSslEvents(WmqSSLEvents.ENABLED);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_SSL_FIPS_REQUIRED) == MQConstants.MQSSL_FIPS_NO) {
				wmqQmanager.setSslFipsRequired(WmqSslFipsRequired.NO);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_SSL_FIPS_REQUIRED) == MQConstants.MQSSL_FIPS_YES) {
				wmqQmanager.setSslFipsRequired(WmqSslFipsRequired.YES);
			}

			wmqQmanager.setSslResetCount((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_SSL_RESET_COUNT));

			wmqQmanager.setStatisticsInterval((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_STATISTICS_INTERVAL));

			wmqQmanager.setSyncpoint((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_SYNCPOINT));

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_TRACE_ROUTE_RECORDING) == MQConstants.MQRECORDING_DISABLED) {
				wmqQmanager.setTraceRouteRecording(WmqTraceRouteRecording.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_TRACE_ROUTE_RECORDING) == MQConstants.MQRECORDING_MSG) {
				wmqQmanager.setTraceRouteRecording(WmqTraceRouteRecording.MESSAGE);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_TRACE_ROUTE_RECORDING) == MQConstants.MQRECORDING_Q) {
				wmqQmanager.setTraceRouteRecording(WmqTraceRouteRecording.QUEUE);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_TREE_LIFE_TIME) != null) {
				wmqQmanager.setTreeLifeTime((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_TREE_LIFE_TIME));
			}
			wmqQmanager.setTriggerInterval((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_TRIGGER_INTERVAL));

			wmqQmanager.setQueueManagerName(((String) pcfMessage.getParameterValue(MQConstants.MQCA_Q_MGR_NAME)).trim());

			wmqQmanager.setQManagerDescription(((String) pcfMessage.getParameterValue(MQConstants.MQCA_Q_MGR_DESC)).trim());

			wmqQmanager.setCodedCharacterSetIdentifier((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CODED_CHAR_SET_ID));

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CHINIT_CONTROL) == MQConstants.MQSVC_CONTROL_MANUAL) {
				wmqQmanager.setChannelInitControl(WmqChannelInitControl.MANUALLY);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_CHINIT_CONTROL) == MQConstants.MQSVC_CONTROL_Q_MGR) {
				wmqQmanager.setChannelInitControl(WmqChannelInitControl.QUEUE_MANAGER);
			}

			wmqQmanager.setDeadLetterQueue(((String) pcfMessage.getParameterValue(MQConstants.MQCA_DEAD_LETTER_Q_NAME)).trim());

			wmqQmanager.setDefaultTransmissionQueue(((String) pcfMessage.getParameterValue(MQConstants.MQCA_DEF_XMIT_Q_NAME)).trim());

			wmqQmanager.setMaxUnCommittedMessages((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MAX_UNCOMMITTED_MSGS));

			wmqQmanager.setCommandInputQueue(((String) pcfMessage.getParameterValue(MQConstants.MQCA_COMMAND_INPUT_Q_NAME)).trim());

			wmqQmanager.setDistributionLists(((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_DIST_LISTS)).intValue());

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MSG_MARK_BROWSE_INTERVAL) != null) {
				wmqQmanager.setMessageMarkBrowseInterval((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MSG_MARK_BROWSE_INTERVAL));
			}
			wmqQmanager.setChannelAutoDefinitionExit(((String) pcfMessage.getParameterValue(MQConstants.MQCA_CHANNEL_AUTO_DEF_EXIT)).trim());

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_ACTIVITY_RECORDING) == MQConstants.MQRECORDING_DISABLED) {
				wmqQmanager.setActivityRecording(WmqActivityRecording.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_ACTIVITY_RECORDING) == MQConstants.MQRECORDING_MSG) {
				wmqQmanager.setActivityRecording(WmqActivityRecording.MESSAGE);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_ACTIVITY_RECORDING) == MQConstants.MQRECORDING_Q) {
				wmqQmanager.setActivityRecording(WmqActivityRecording.QUEUE);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_INHIBIT_EVENT) == MQConstants.MQEVR_DISABLED) {
				wmqQmanager.setInhibitEvents(WmqInhibitEvents.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_INHIBIT_EVENT) == MQConstants.MQEVR_ENABLED) {
				wmqQmanager.setInhibitEvents(WmqInhibitEvents.ENABLED);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_LOCAL_EVENT) == MQConstants.MQEVR_DISABLED) {
				wmqQmanager.setLocalEvents(WmqLocalEvents.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_LOCAL_EVENT) == MQConstants.MQEVR_ENABLED) {
				wmqQmanager.setLocalEvents(WmqLocalEvents.ENABLED);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_REMOTE_EVENT) == MQConstants.MQEVR_DISABLED) {
				wmqQmanager.setRemoteEvents(WmqRemoteEvents.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_REMOTE_EVENT) == MQConstants.MQEVR_ENABLED) {
				wmqQmanager.setRemoteEvents(WmqRemoteEvents.ENABLED);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_START_STOP_EVENT) == MQConstants.MQEVR_DISABLED) {
				wmqQmanager.setStartAndStopEvents(WmqStartAndStopEvents.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_START_STOP_EVENT) == MQConstants.MQEVR_ENABLED) {
				wmqQmanager.setStartAndStopEvents(WmqStartAndStopEvents.ENABLED);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PERFORMANCE_EVENT) == MQConstants.MQEVR_DISABLED) {
				wmqQmanager.setPerformanceEvents(WmqPerformanceEvents.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PERFORMANCE_EVENT) == MQConstants.MQEVR_ENABLED) {
				wmqQmanager.setPerformanceEvents(WmqPerformanceEvents.ENABLED);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_LOGGER_EVENT) == MQConstants.MQEVR_DISABLED) {
				wmqQmanager.setLoggerEvents(WmqLoggerEvents.DISABLED);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_LOGGER_EVENT) == MQConstants.MQEVR_ENABLED) {
				wmqQmanager.setLoggerEvents(WmqLoggerEvents.ENABLED);
			}

			wmqQmanager.setRevocationNameList(((String) pcfMessage.getParameterValue(MQConstants.MQCA_SSL_CRL_NAMELIST)).trim());

			wmqQmanager.setCryptographicHardware(((String) pcfMessage.getParameterValue(MQConstants.MQCA_SSL_CRYPTO_HARDWARE)).trim());

			wmqQmanager.setKeyRepository(((String) pcfMessage.getParameterValue(MQConstants.MQCA_SSL_KEY_REPOSITORY)).trim());

			wmqQmanager.setKeyRepository(((String) pcfMessage.getParameterValue(MQConstants.MQCA_SSL_KEY_REPOSITORY)).trim());

			wmqQmanager.setQmid(((String) pcfMessage.getParameterValue(MQConstants.MQCA_Q_MGR_IDENTIFIER)).trim());

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_AUTO_CLUSSDR) == MQConstants.MQMON_HIGH) {
				wmqQmanager.setAutoClussdrMonitoring(WmqAutoCLUSSDRMonitoring.HIGH);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_AUTO_CLUSSDR) == MQConstants.MQMON_Q_MGR) {
				wmqQmanager.setAutoClussdrMonitoring(WmqAutoCLUSSDRMonitoring.QUEUEMANAGER);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_AUTO_CLUSSDR) == MQConstants.MQMON_OFF) {
				wmqQmanager.setAutoClussdrMonitoring(WmqAutoCLUSSDRMonitoring.OFF);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_AUTO_CLUSSDR) == MQConstants.MQMON_LOW) {
				wmqQmanager.setAutoClussdrMonitoring(WmqAutoCLUSSDRMonitoring.LOW);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_MONITORING_AUTO_CLUSSDR) == MQConstants.MQMON_MEDIUM) {
				wmqQmanager.setAutoClussdrMonitoring(WmqAutoCLUSSDRMonitoring.MEDIUM);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_STATISTICS_AUTO_CLUSSDR) == MQConstants.MQMON_HIGH) {
				wmqQmanager.setAutoClussdrStatistics(WmqAutoCLUSSDRStatistics.HIGH);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_STATISTICS_AUTO_CLUSSDR) == MQConstants.MQMON_OFF) {
				wmqQmanager.setAutoClussdrStatistics(WmqAutoCLUSSDRStatistics.OFF);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_STATISTICS_AUTO_CLUSSDR) == MQConstants.MQMON_LOW) {
				wmqQmanager.setAutoClussdrStatistics(WmqAutoCLUSSDRStatistics.LOW);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_STATISTICS_AUTO_CLUSSDR) == MQConstants.MQMON_Q_MGR) {
				wmqQmanager.setAutoClussdrStatistics(WmqAutoCLUSSDRStatistics.QUEUEMANAGER);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_STATISTICS_AUTO_CLUSSDR) == MQConstants.MQMON_MEDIUM) {
				wmqQmanager.setAutoClussdrStatistics(WmqAutoCLUSSDRStatistics.MEDIUM);
			}

			if (((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_MODE)) != null
			        && (Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_MODE) == MQConstants.MQPSM_COMPAT) {
				wmqQmanager.setPublishSubscribeMode(WmqPublishSubscribeMode.COMPATIBILITY);
			} else if (((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_MODE)) != null
			        && (Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_MODE) == MQConstants.MQPSM_DISABLED) {
				wmqQmanager.setPublishSubscribeMode(WmqPublishSubscribeMode.DISABLED);
			} else if (((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_MODE)) != null
			        && (Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_MODE) == MQConstants.MQPSM_ENABLED) {
				wmqQmanager.setPublishSubscribeMode(WmqPublishSubscribeMode.ENABLE);
			}

			if ((pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_SYNC_PT)) != null
			        && (Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_SYNC_PT) == MQConstants.MQSYNCPOINT_IFPER) {
				wmqQmanager.setPublishSubscribeSyncPoint(WmqPublishSubscribeSyncPoint.IF_PERSISTENT);
			} else if ((pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_SYNC_PT)) != null
			        && (Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_SYNC_PT) == MQConstants.MQSYNCPOINT_YES) {
				wmqQmanager.setPublishSubscribeSyncPoint(WmqPublishSubscribeSyncPoint.YES);
			}

			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_NP_RESP) != null
			        && (Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_NP_RESP) == MQConstants.MQUNDELIVERED_NORMAL) {
				wmqQmanager.setUndeliveredNonPersistentResponse(WmqUndeliveredNonPersistentResponse.NORMAL);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_NP_RESP) != null
			        && (Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_NP_RESP) == MQConstants.MQUNDELIVERED_DISCARD) {
				wmqQmanager.setUndeliveredNonPersistentResponse(WmqUndeliveredNonPersistentResponse.DISACRD);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_NP_RESP) != null
			        && (Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_NP_RESP) == MQConstants.MQUNDELIVERED_SAFE) {
				wmqQmanager.setUndeliveredNonPersistentResponse(WmqUndeliveredNonPersistentResponse.SAFE);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_NP_RESP) != null
			        && (Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_NP_RESP) == MQConstants.MQUNDELIVERED_KEEP) {
				wmqQmanager.setUndeliveredNonPersistentResponse(WmqUndeliveredNonPersistentResponse.KEEP);
			}

			if (((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_NP_MSG) != null)
			        && ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_NP_MSG) == MQConstants.MQUNDELIVERED_DISCARD)) {
				wmqQmanager.setUndeliveredNonPersistentInputMessage(WmqUndeliveredNonPersistentInputMessage.DISCARD);
			} else if (((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_NP_MSG) != null)
			        && ((Integer) pcfMessage.getParameterValue(MQConstants.MQIA_PUBSUB_NP_MSG) == MQConstants.MQUNDELIVERED_DISCARD)) {
				wmqQmanager.setUndeliveredNonPersistentInputMessage(WmqUndeliveredNonPersistentInputMessage.KEEP);
			}

			wmqQmanager.setFullRepositoryForaCluster(((String) pcfMessage.getParameterValue(MQConstants.MQCA_REPOSITORY_NAME)).trim());

			wmqQmanager.setFullRepositoryForListOfClusters(((String) pcfMessage.getParameterValue(MQConstants.MQCA_REPOSITORY_NAMELIST)).trim());

			wmqQmanager.setAlterationDate(((String) pcfMessage.getParameterValue(MQConstants.MQCA_ALTERATION_DATE)).trim());
			wmqQmanager.setAlterationTime(((String) pcfMessage.getParameterValue(MQConstants.MQCA_ALTERATION_TIME)).trim());
			wmqQmanager.setCreationDate(((String) pcfMessage.getParameterValue(MQConstants.MQCA_CREATION_DATE)).trim());
			wmqQmanager.setCreationTime(((String) pcfMessage.getParameterValue(MQConstants.MQCA_CREATION_TIME)).trim());

			ctx.logOutput("Operation Successfull");
			ctx.logOutput("QueueManager \"" + wmqQmanager.getQueueManagerName() + "\" is inquired Successfully");
		} else {
			ctx.logOutput("Response is null");
		}

	}

	public String getDescription() {

		return "Inquiring the attributes of the QueueManager \"" + wmqQmanager.getQueueManagerName() + "\"";
	}

	@Override
	protected String getSuccessMessage() {

		return null;

	}

}
