/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFException;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.utils.MQPluginException;
import com.xebialabs.deployit.plugin.wmq.utils.PCF_CommonMethods;
import com.xebialabs.deployit.plugin.wmq.utils.WmqHelper;

/**
 * Inquires the {@link WmqQueueManager} to get the Cluster names to which it is a member.
 */
@SuppressWarnings("serial")
public class InquireWmqQueueManagerClusterStep implements Step {

	protected WmqQueueManager wmqQmanager;
	protected int mqCommand;

	protected void init() {
		this.mqCommand = MQConstants.MQCMD_INQUIRE_CLUSTER_Q_MGR;

	}

	public InquireWmqQueueManagerClusterStep(WmqQueueManager wmqQmanager) {

		this.wmqQmanager = wmqQmanager;
	}

	public void setPCFMessageParameters(PCFMessage pcfCmd) throws MQPluginException {

		pcfCmd.addParameter(MQConstants.MQCA_CLUSTER_Q_MGR_NAME, wmqQmanager.getQueueManagerName());
	}

	public boolean execute(StepExecutionContext ctx) {
		init();
		PCF_CommonMethods pcfCM = new PCF_CommonMethods();

		try {
			WmqHelper.createAgent(wmqQmanager, pcfCM, ctx);
			PCFMessage pcfCmd = new PCFMessage(mqCommand);
			setPCFMessageParameters(pcfCmd);
			PCFMessage[] pcfResponse = WmqHelper.sendPcfcmCommandToAgent(pcfCM, pcfCmd);
			readPCFMessageResponse(ctx, pcfResponse);
			pcfCM.destroyAgent();
		} catch (Exception e) {
			if (e.getClass().equals(PCFException.class)) {
				PCFException pcfe = (PCFException) e;

				if (pcfe.reasonCode == MQConstants.MQRC_UNKNOWN_OBJECT_NAME) {
					ctx.logOutput("No Clusters found for the QueueManager \"" + wmqQmanager.getQueueManagerName() + "\"");
					return true;
				}
			}

			pcfCM.displayException(e, ctx);
			return false;
		}
		return true;

	}

	protected void readPCFMessageResponse(StepExecutionContext ctx, PCFMessage[] pcfResponse) {
		if (pcfResponse != null) {
			StringBuffer sb = new StringBuffer();
			boolean firstTime = true;
			for (PCFMessage pcfMessage : pcfResponse) {
				if (!firstTime) {
					sb.append(",");
				}
				sb.append(((String) pcfMessage.getParameterValue(MQConstants.MQCA_CLUSTER_NAME)).trim());
				firstTime = false;
			}

			wmqQmanager.setClusterName(sb.toString());

			ctx.logOutput("The queue manager \"" + wmqQmanager.getQueueManagerName() + "\" is a member of below clusters:\n" + wmqQmanager.getClusterName());

		} else {
			ctx.logOutput("Response is null");
		}

	}

	public String getDescription() {

		return "Inquiring and displaying Clusters of a QueueManager \"" + wmqQmanager.getQueueManagerName() + "\"";
	}

}
