/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wmq.ci.WmqChannel;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;

/**
 * Display the status of the channel {@link WmqChannel} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
@Deprecated
public class DisplayWmqChannelStatusStep extends BaseWmqStep {

	private WmqChannel channel;

	public DisplayWmqChannelStatusStep(WmqChannel channel, WmqQueueManager wmqQmanager)

	{

		this.channel = channel;
		this.wmqQmanager = wmqQmanager;

	}

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_INQUIRE_CHANNEL_STATUS;

	}

	@Override
	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		pcfCmd.addParameter(MQConstants.MQCACH_CHANNEL_NAME, channel.getChannelName());

	}

	@Override
	protected void readPCFMessageResponse(StepExecutionContext ctx, PCFMessage pcfMessage) {

		int chStatus = ((Integer) (pcfMessage.getParameterValue(MQConstants.MQIACH_CHANNEL_STATUS))).intValue();

		String[] chStatusText = { "", "CHANNEL_BINDING", "CHANNEL_STARTING", "CHANNEL_RUNNING", "CHANNEL_STOPPING", "CHANNEL_RETRYING", "CHANNEL_STOPPED",
		        "CHANNEL_REQUESTING", "CHANNEL_PAUSED", "", "", "", "", "CHANNEL_INITIALIZING" };

		ctx.logOutput(chStatusText[chStatus]);

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Dispaly ChannelStatus of \"" + this.wmqQmanager.getQueueManagerName() + "\"";
		}
		return "Dispaly ChannelStatus Step";
	}

	@Override
	protected String getSuccessMessage() {

		return null;

	}

}
