/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqNetBIOSListener;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqListenerControl;

/**
 * Creates a {@link WmqNetBIOSListener} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqNetBIOSListenerStep extends BaseWmqStep {

	public WmqNetBIOSListener wmqNetBiosListener;

	public CreateWmqNetBIOSListenerStep(WmqNetBIOSListener wmqNetBiosListener, WmqQueueManager wmqQmanager) {

		this.wmqNetBiosListener = wmqNetBiosListener;
		this.wmqQmanager = wmqQmanager;
	}

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_CREATE_LISTENER;

	}

	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		// ListenerName - Mandatory.
		pcfCmd.addParameter(MQConstants.MQCACH_LISTENER_NAME, wmqNetBiosListener.getListenerName());

		// Listener protocolType - Mandatory
		pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_NETBIOS);

		// Adapter -optional
		pcfCmd.addParameter(MQConstants.MQIACH_ADAPTER, wmqNetBiosListener.getAdapter());
		// LocalName -optional
		pcfCmd.addParameter(MQConstants.MQCACH_LOCAL_NAME, wmqNetBiosListener.getLocalName());
		// SessionCount -optional
		pcfCmd.addParameter(MQConstants.MQIACH_SESSION_COUNT, wmqNetBiosListener.getSessionCount());
		// CommandCount -optional
		pcfCmd.addParameter(MQConstants.MQIACH_COMMAND_COUNT, wmqNetBiosListener.getCommandCount());
		// Description -optional
		pcfCmd.addParameter(MQConstants.MQCACH_LISTENER_DESC, wmqNetBiosListener.getDescription());

		// NameCount -optional
		pcfCmd.addParameter(MQConstants.MQIACH_NAME_COUNT, wmqNetBiosListener.getNameCount());

		// Control -optional

		if (WmqListenerControl.MANUAL == wmqNetBiosListener.getControl()) {
			pcfCmd.addParameter(MQConstants.MQIACH_LISTENER_CONTROL, MQConstants.MQSVC_CONTROL_MANUAL);

		} else if (WmqListenerControl.QUEUE_MANAGER == wmqNetBiosListener.getControl()) {

			pcfCmd.addParameter(MQConstants.MQIACH_LISTENER_CONTROL, MQConstants.MQSVC_CONTROL_Q_MGR);
		} else if (WmqListenerControl.QUEUE_MANAGER_START == wmqNetBiosListener.getControl()) {

			pcfCmd.addParameter(MQConstants.MQIACH_LISTENER_CONTROL, MQConstants.MQSVC_CONTROL_Q_MGR_START);
		}
	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating NetBIOSListener \"" + wmqNetBiosListener.getListenerName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName()
			        + "\"";
		}
		return "Creating NetBIOSListener Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The NetBIOSListener \"" + wmqNetBiosListener.getListenerName() + "\" is created on QueueManager\"" + this.wmqQmanager.getQueueManagerName()
		        + "\"";

	}

}
