/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqModelQueue;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultInputOpenOption;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPersistence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPutResponseType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultReadAhead;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefinitionType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDistributionLists;
import com.xebialabs.deployit.plugin.wmq.enums.WmqGetMessages;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHardengetBackout;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMessageDeliverySequence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNPMClass;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPutMessage;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueAccounting;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthHighEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthLowEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthMaxEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueServiceIntervalEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueStatistics;
import com.xebialabs.deployit.plugin.wmq.enums.WmqShareability;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTriggerControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTriggerType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqUsage;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

/**
 * Creates a {@link WmqModelQueue} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqModelQueueStep extends BaseWmqStep {

	public WmqModelQueue wmqModelQueue;

	@Override
	protected void init() {

		this.mqCommand = MQConstants.MQCMD_CREATE_Q;

	}

	public CreateWmqModelQueueStep(WmqModelQueue wmqModelQueue, WmqQueueManager wmqQmanager) {
		this.wmqModelQueue = wmqModelQueue;
		this.wmqQmanager = wmqQmanager;
	}

	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		// Model Queue name - Mandatory.
		pcfCmd.addParameter(MQConstants.MQCA_Q_NAME, wmqModelQueue.getQueueName());

		// Queue Type - Optional.This value is mentioned here itself.
		pcfCmd.addParameter(MQConstants.MQIA_Q_TYPE, MQConstants.MQQT_MODEL);

		// Default persistent of the Alias Queue is either Persistent or NotPersistent.
		if (WmqDefaultPersistence.PERSISTENT == wmqModelQueue.getDefaultPersistence()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_PERSISTENCE, MQConstants.MQPER_PERSISTENT);
		} else if (WmqDefaultPersistence.NOT_PERSISTENT == wmqModelQueue.getDefaultPersistence()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_PERSISTENCE, MQConstants.MQPER_NOT_PERSISTENT);
		}

		// PutMessage value of Model queue may be either Allowed or Inhibited.

		if (WmqPutMessage.ALLOWED == wmqModelQueue.getPutMessages()) {
			pcfCmd.addParameter(MQConstants.MQIA_INHIBIT_PUT, MQConstants.MQQA_PUT_ALLOWED);
		} else if (WmqPutMessage.INHIBITED == wmqModelQueue.getPutMessages()) {
			pcfCmd.addParameter(MQConstants.MQIA_INHIBIT_PUT, MQConstants.MQQA_PUT_INHIBITED);
		}

		// Description of the Model Queue.
		if (StringUtils.isNotBlank(wmqModelQueue.getDescription())) {
			pcfCmd.addParameter(MQConstants.MQCA_Q_DESC, wmqModelQueue.getDescription());
		}

		// Default Priority for Alias Queue
		pcfCmd.addParameter(MQConstants.MQIA_DEF_PRIORITY, wmqModelQueue.getDefaultPriority());

		if (wmqQmanager.getVersion() != WmqVersion.WMQ_60) {

			// DefaultPutResponseType value may be either Synchronous or Asynchronous.
			if (WmqDefaultPutResponseType.SYNCHRONOUS == wmqModelQueue.getDefaultPutResponseType()) {
				pcfCmd.addParameter(MQConstants.MQIA_DEF_PUT_RESPONSE_TYPE, MQConstants.MQPRT_SYNC_RESPONSE);
			} else if (WmqDefaultPutResponseType.ASYNCHRONOUS == wmqModelQueue.getDefaultPutResponseType()) {
				pcfCmd.addParameter(MQConstants.MQIA_DEF_PUT_RESPONSE_TYPE, MQConstants.MQPRT_ASYNC_RESPONSE);
			}

			// DefaultReadAhead value may be either Yes or No or Disabled.
			if (WmqDefaultReadAhead.YES == wmqModelQueue.getDefaultReadAhead()) {
				pcfCmd.addParameter(MQConstants.MQIA_DEF_READ_AHEAD, MQConstants.MQREADA_YES);
			} else if (WmqDefaultReadAhead.NO == wmqModelQueue.getDefaultReadAhead()) {
				pcfCmd.addParameter(MQConstants.MQIA_DEF_READ_AHEAD, MQConstants.MQREADA_NO);
			} else if (WmqDefaultReadAhead.DISABLED == wmqModelQueue.getDefaultReadAhead()) {
				pcfCmd.addParameter(MQConstants.MQIA_DEF_READ_AHEAD, MQConstants.MQREADA_DISABLED);
			}

			// Property Control value may be either Compatability,None,All,ForceMQRFH2.
			if (WmqPropertyControl.COMPATABILITY == wmqModelQueue.getPropertyControl()) {
				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_COMPATIBILITY);
			} else if (WmqPropertyControl.NONE == wmqModelQueue.getPropertyControl()) {
				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_NONE);
			} else if (WmqPropertyControl.ALL == wmqModelQueue.getPropertyControl()) {
				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_ALL);
			} else if (WmqPropertyControl.FORCE_MQ_RFH2 == wmqModelQueue.getPropertyControl()) {
				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_FORCE_MQRFH2);
			}
		}
		// GetMessages value may be either Allowed or Inhibited.
		if (WmqGetMessages.ALLOWED == wmqModelQueue.getGetMessages()) {
			pcfCmd.addParameter(MQConstants.MQIA_INHIBIT_GET, MQConstants.MQQA_GET_ALLOWED);
		} else if (WmqGetMessages.INHIBITED == wmqModelQueue.getGetMessages()) {
			pcfCmd.addParameter(MQConstants.MQIA_INHIBIT_GET, MQConstants.MQQA_GET_INHIBITED);
		}

		// DefaultInputOpenOption value may be either InputExclusive,InputShared.
		if (WmqDefaultInputOpenOption.INPUT_EXCLUSIVE == wmqModelQueue.getDefaultInputOpenOption()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_INPUT_OPEN_OPTION, MQConstants.MQOO_INPUT_EXCLUSIVE);
		} else if (WmqDefaultInputOpenOption.INPUT_SHARED == wmqModelQueue.getDefaultInputOpenOption()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_INPUT_OPEN_OPTION, MQConstants.MQOO_INPUT_SHARED);
		}
		// Shareability value may be either Shareable, NotShareable.
		if (WmqShareability.SHAREABLE == wmqModelQueue.getShareability()) {
			pcfCmd.addParameter(MQConstants.MQIA_SHAREABILITY, MQConstants.MQQA_SHAREABLE);
		} else if (WmqShareability.NOT_SHAREABLE == wmqModelQueue.getShareability()) {
			pcfCmd.addParameter(MQConstants.MQIA_SHAREABILITY, MQConstants.MQQA_NOT_SHAREABLE);
		}

		// DistributionLists value may be either Supported or NotSupported.
		if (WmqDistributionLists.SUPPORTED == wmqModelQueue.getDistributionLists()) {
			pcfCmd.addParameter(MQConstants.MQIA_DIST_LISTS, MQConstants.MQDL_SUPPORTED);
		} else if (WmqDistributionLists.NOT_SUPPORTED == wmqModelQueue.getDistributionLists()) {
			pcfCmd.addParameter(MQConstants.MQIA_DIST_LISTS, MQConstants.MQDL_NOT_SUPPORTED);
		}

		// * TriggerControl value may be either Off or On.
		if (WmqTriggerControl.OFF == wmqModelQueue.getTriggerControl()) {
			pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_CONTROL, MQConstants.MQTC_OFF);
		} else if (WmqTriggerControl.ON == wmqModelQueue.getTriggerControl()) {
			pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_CONTROL, MQConstants.MQTC_ON);
		}

		// TriggerType value may be either Depth or Every or First or None.
		if (WmqTriggerType.DEPTH == wmqModelQueue.getTriggerType()) {
			pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_TYPE, MQConstants.MQTT_DEPTH);
		} else if (WmqTriggerType.EVERY == wmqModelQueue.getTriggerType()) {
			pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_TYPE, MQConstants.MQTT_EVERY);
		} else if (WmqTriggerType.FIRST == wmqModelQueue.getTriggerType()) {
			pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_TYPE, MQConstants.MQTT_FIRST);
		} else if (WmqTriggerType.NONE == wmqModelQueue.getTriggerType()) {
			pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_TYPE, MQConstants.MQTT_NONE);
		}

		// TriggerDepth value should be in the range 1 through 999 999 999.
		if (wmqModelQueue.getTriggerDepth() != 0) {
			pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_DEPTH, wmqModelQueue.getTriggerDepth());
		}
		// TriggerMessagePriority value should be in the range through 0 to 9.
		pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_MSG_PRIORITY, wmqModelQueue.getTriggerMessagePriority());

		// TriggerData specifies user data that the queue manager includes in the trigger message.
		pcfCmd.addParameter(MQConstants.MQCA_TRIGGER_DATA, wmqModelQueue.getTriggerData());
		// InitiationQueue is the model queue for trigger messages relating to this queue.
		if (wmqModelQueue.getInitiationQueue() != null && !"".equals(wmqModelQueue.getInitiationQueue())) {
			pcfCmd.addParameter(MQConstants.MQCA_INITIATION_Q_NAME, wmqModelQueue.getInitiationQueue());
		}
		// ProcessName specifies the model name of the WebSphere MQ process
		if (wmqModelQueue.getProcessName() != null && !"".equals(wmqModelQueue.getProcessName())) {
			pcfCmd.addParameter(MQConstants.MQCA_PROCESS_NAME, wmqModelQueue.getProcessName());
		}
		// QueueDepthMaxEvents value may be either Enabled,Disabled.
		if (WmqQueueDepthMaxEvents.ENABLED == wmqModelQueue.getQueueDepthMaxEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_MAX_EVENT, MQConstants.MQEVR_ENABLED);
		} else if (WmqQueueDepthMaxEvents.DISABLED == wmqModelQueue.getQueueDepthMaxEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_MAX_EVENT, MQConstants.MQEVR_DISABLED);
		}
		// QueueDepthHighEvents value may be either Disabled or Enabled.
		if (WmqQueueDepthHighEvents.ENABLED == wmqModelQueue.getQueueDepthHighEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_HIGH_EVENT, MQConstants.MQEVR_ENABLED);
		} else if (WmqQueueDepthHighEvents.DISABLED == wmqModelQueue.getQueueDepthHighEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_HIGH_EVENT, MQConstants.MQEVR_DISABLED);
		}
		// QueueDepthHighLimit value must be greater than or equal to zero and less than or equal to 100.The default value is 80.
		pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_HIGH_LIMIT, wmqModelQueue.getQueueDepthHighLimit());
		// QueueDepthLowLimit value range from 0 to 100.The default value is 20.
		pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_LOW_LIMIT, wmqModelQueue.getQueueDepthLowLimit());
		// QueueDepthLowEvents value may be either Enabled,Disabled.
		if (WmqQueueDepthLowEvents.ENABLED == wmqModelQueue.getQueueDepthLowEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_LOW_EVENT, MQConstants.MQEVR_ENABLED);
		} else if (WmqQueueDepthLowEvents.DISABLED == wmqModelQueue.getQueueDepthLowEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_LOW_EVENT, MQConstants.MQEVR_DISABLED);
		}
		// QueueServiceIntervalEvents value may be either High or None or Ok.
		if (WmqQueueServiceIntervalEvents.HIGH == wmqModelQueue.getQueueServiceIntervalEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_SERVICE_INTERVAL_EVENT, MQConstants.MQQSIE_HIGH);
		} else if (WmqQueueServiceIntervalEvents.OK == wmqModelQueue.getQueueServiceIntervalEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_SERVICE_INTERVAL_EVENT, MQConstants.MQQSIE_OK);
		} else if (WmqQueueServiceIntervalEvents.NONE == wmqModelQueue.getQueueServiceIntervalEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_SERVICE_INTERVAL_EVENT, MQConstants.MQQSIE_NONE);
		}

		// QueueServiceInterval value is in the range through 0 to 999 999 999 milliseconds.
		pcfCmd.addParameter(MQConstants.MQIA_Q_SERVICE_INTERVAL, wmqModelQueue.getQueueServiceInterval());
		// BackoutRequeueQueue specifies the model name of the queue to which a message is transferred.
		if (wmqModelQueue.getBackoutRequeueQueue() != null && !"".equals(wmqModelQueue.getBackoutRequeueQueue())) {
			pcfCmd.addParameter(MQConstants.MQCA_BACKOUT_REQ_Q_NAME, wmqModelQueue.getBackoutRequeueQueue());
		}
		// BackoutThreshold value is in the range 0 through 999 999 999.
		pcfCmd.addParameter(MQConstants.MQIA_BACKOUT_THRESHOLD, wmqModelQueue.getBackoutThreshold());
		// HardengetBackout value Specifies whether the count of backed out messages is saved across restarts of the message queuemanager.
		if (WmqHardengetBackout.HARDENED == wmqModelQueue.getHardengetBackout()) {
			pcfCmd.addParameter(MQConstants.MQIA_HARDEN_GET_BACKOUT, MQConstants.MQQA_BACKOUT_HARDENED);
		} else if (WmqHardengetBackout.NOT_HARDENED == wmqModelQueue.getHardengetBackout()) {
			pcfCmd.addParameter(MQConstants.MQIA_HARDEN_GET_BACKOUT, MQConstants.MQQA_BACKOUT_NOT_HARDENED);
		}
		// NPMClass value may be either Normal or High.
		if (WmqNPMClass.NORMAL == wmqModelQueue.getNpmClass()) {
			pcfCmd.addParameter(MQConstants.MQIA_NPM_CLASS, MQConstants.MQNPM_CLASS_NORMAL);
		} else if (WmqNPMClass.HIGH == wmqModelQueue.getNpmClass()) {
			pcfCmd.addParameter(MQConstants.MQIA_NPM_CLASS, MQConstants.MQNPM_CLASS_HIGH);
		}
		// QueueMonitoring specifies whether online monitoring data is to be collected and, if so, the rate at which the data is collected.
		if (WmqQueueMonitoring.HIGH == wmqModelQueue.getQueueMonitoring()) {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_Q, MQConstants.MQMON_HIGH);
		} else if (WmqQueueMonitoring.LOW == wmqModelQueue.getQueueMonitoring()) {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_Q, MQConstants.MQMON_LOW);
		} else if (WmqQueueMonitoring.MEDIUM == wmqModelQueue.getQueueMonitoring()) {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_Q, MQConstants.MQMON_MEDIUM);
		} else if (WmqQueueMonitoring.QUEUE_MANAGER == wmqModelQueue.getQueueMonitoring()) {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_Q, MQConstants.MQMON_Q_MGR);
		} else if (WmqQueueMonitoring.OFF == wmqModelQueue.getQueueMonitoring()) {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_Q, MQConstants.MQMON_OFF);
		}

		// QueueStatistics specifies statistics data collection is enabled or not.
		if (WmqQueueStatistics.ON == wmqModelQueue.getQueueStatistics()) {
			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_Q, MQConstants.MQMON_ON);
		} else if (WmqQueueStatistics.OFF == wmqModelQueue.getQueueStatistics()) {
			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_Q, MQConstants.MQMON_OFF);
		} else if (WmqQueueStatistics.QUEUE_MANAGER == wmqModelQueue.getQueueStatistics()) {
			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_Q, MQConstants.MQMON_Q_MGR);
		}

		// QueueAccounting controls the collection of accounting data.
		if (WmqQueueAccounting.ON == wmqModelQueue.getQueueAccounting()) {
			pcfCmd.addParameter(MQConstants.MQIA_ACCOUNTING_Q, MQConstants.MQMON_ON);
		} else if (WmqQueueAccounting.OFF == wmqModelQueue.getQueueAccounting()) {
			pcfCmd.addParameter(MQConstants.MQIA_ACCOUNTING_Q, MQConstants.MQMON_OFF);
		} else if (WmqQueueAccounting.QUEUE_MANAGER == wmqModelQueue.getQueueAccounting()) {
			pcfCmd.addParameter(MQConstants.MQIA_ACCOUNTING_Q, MQConstants.MQMON_Q_MGR);
		}
		// MaxQueueDepth of the model queue varies through 0 to 999 999 999.
		pcfCmd.addParameter(MQConstants.MQIA_MAX_Q_DEPTH, wmqModelQueue.getMaxQueueDepth());
		// MaxMsgLength of the model queue varies through 0 to 999 999 999.
		pcfCmd.addParameter(MQConstants.MQIA_MAX_MSG_LENGTH, wmqModelQueue.getMaxMessageLength());
		// MessageDeliverySequence value may be either Priority or Fifo.
		if (WmqMessageDeliverySequence.PRIORITY == wmqModelQueue.getMessageDeliverySequence()) {
			pcfCmd.addParameter(MQConstants.MQIA_MSG_DELIVERY_SEQUENCE, MQConstants.MQMDS_PRIORITY);
		} else if (WmqMessageDeliverySequence.FIFO == wmqModelQueue.getMessageDeliverySequence()) {
			pcfCmd.addParameter(MQConstants.MQIA_MSG_DELIVERY_SEQUENCE, MQConstants.MQMDS_FIFO);
		}
		// DefinitionType value may be either PermanentDynamic or TemporaryDynamic.
		if (WmqDefinitionType.TEMPORARY_DYNAMIC == wmqModelQueue.getDefifnitionType()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEFINITION_TYPE, MQConstants.MQQDT_TEMPORARY_DYNAMIC);
		} else if (WmqDefinitionType.PERMANENT_DYNAMIC == wmqModelQueue.getDefifnitionType()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEFINITION_TYPE, MQConstants.MQQDT_PERMANENT_DYNAMIC);
		}
		// Retention Interval value may be through 0 to 999 999 999.
		pcfCmd.addParameter(MQConstants.MQIA_RETENTION_INTERVAL, wmqModelQueue.getRetentionInterval());
		// Usage value tells whether the queue is an normal or transmission queue.
		if (WmqUsage.NORMAL == wmqModelQueue.getUsage()) {
			pcfCmd.addParameter(MQConstants.MQIA_USAGE, MQConstants.MQUS_NORMAL);
		} else if (WmqUsage.TRANSMISSION == wmqModelQueue.getUsage()) {
			pcfCmd.addParameter(MQConstants.MQIA_USAGE, MQConstants.MQUS_TRANSMISSION);
		}

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating ModelQueue  \"" + wmqModelQueue.getQueueName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
		}
		return "Creating ModelQueue Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The ModelQueue \"" + wmqModelQueue.getQueueName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";

	}

}
