/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

/**CreateWmqAliasQueueStep is a step, with which we are able to create a Alias Queue ie., Websphere MQ object.We are using PCF commands to create alias queue in WMQ. */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqAliasQueue;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqBaseType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultBindType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPersistence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPutResponseType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultReadAhead;
import com.xebialabs.deployit.plugin.wmq.enums.WmqGetMessages;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPutMessage;
import com.xebialabs.deployit.plugin.wmq.enums.WmqScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.utils.MQPluginException;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

/**
 * Creates a {@link WmqAliasQueue} in a {@link WmqQueueManager}
 */

@SuppressWarnings("serial")
public class CreateWmqAliasQueueStep extends BaseWmqStep {

	public WmqAliasQueue wmqAliasQueue;

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_CREATE_Q;

	}

	public CreateWmqAliasQueueStep(WmqAliasQueue wmqAliasQueue, WmqQueueManager wmqQmanager) {

		this.wmqAliasQueue = wmqAliasQueue;
		this.wmqQmanager = wmqQmanager;
	}

	public void setPCFMessageParameters(PCFMessage pcfCmd) throws MQPluginException {

		// Alias Queue name - Mandatory.

		pcfCmd.addParameter(MQConstants.MQCA_Q_NAME, wmqAliasQueue.getQueueName());

		// Alias Queue Type - Optional.This value is mentioned here itself.

		pcfCmd.addParameter(MQConstants.MQIA_Q_TYPE, MQConstants.MQQT_ALIAS);

		// Name of the Base Object.This value may be the name of a queue or topic which is already existed.

		pcfCmd.addParameter(MQConstants.MQCA_BASE_OBJECT_NAME, wmqAliasQueue.getBaseObject());

		if (wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
			// Type of the Base object.

			if (WmqBaseType.QUEUE == wmqAliasQueue.getBaseType()) {
				pcfCmd.addParameter(MQConstants.MQIA_BASE_TYPE, MQConstants.MQOT_Q);
			} else if (WmqBaseType.TOPIC == wmqAliasQueue.getBaseType()) {
				pcfCmd.addParameter(MQConstants.MQIA_BASE_TYPE, MQConstants.MQOT_TOPIC);
			}

			// DefaultPutResponseType value may be either Synchronous or Asynchronous.

			if (WmqDefaultPutResponseType.SYNCHRONOUS == wmqAliasQueue.getDefaultPutResponseType()) {

				pcfCmd.addParameter(MQConstants.MQIA_DEF_PUT_RESPONSE_TYPE, MQConstants.MQPRT_SYNC_RESPONSE);
			} else if (WmqDefaultPutResponseType.ASYNCHRONOUS == wmqAliasQueue.getDefaultPutResponseType()) {

				pcfCmd.addParameter(MQConstants.MQIA_DEF_PUT_RESPONSE_TYPE, MQConstants.MQPRT_ASYNC_RESPONSE);
			}

			// DefaultReadAhead value may be either Yes or No or Disabled.

			if (WmqDefaultReadAhead.YES == wmqAliasQueue.getDefaultReadAhead()) {

				pcfCmd.addParameter(MQConstants.MQIA_DEF_READ_AHEAD, MQConstants.MQREADA_YES);
			} else if (WmqDefaultReadAhead.NO == wmqAliasQueue.getDefaultReadAhead()) {

				pcfCmd.addParameter(MQConstants.MQIA_DEF_READ_AHEAD, MQConstants.MQREADA_NO);
			} else if (WmqDefaultReadAhead.DISABLED == wmqAliasQueue.getDefaultReadAhead()) {

				pcfCmd.addParameter(MQConstants.MQIA_DEF_READ_AHEAD, MQConstants.MQREADA_DISABLED);
			}

			// Property Control value may be either Compatability,None,All,ForceMQRFH2.

			if (WmqPropertyControl.COMPATABILITY == wmqAliasQueue.getPropertyControl()) {

				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_COMPATIBILITY);
			} else if (WmqPropertyControl.NONE == wmqAliasQueue.getPropertyControl()) {

				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_NONE);
			} else if (WmqPropertyControl.ALL == wmqAliasQueue.getPropertyControl()) {

				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_ALL);
			} else if (WmqPropertyControl.FORCE_MQ_RFH2 == wmqAliasQueue.getPropertyControl()) {

				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_FORCE_MQRFH2);
			}

		}
		// CLWLqueuerank consists of the value in the range through 0 to 9.

		pcfCmd.addParameter(MQConstants.MQIA_CLWL_Q_RANK, wmqAliasQueue.getClwlQueueRank());

		// CLWLqueuepriority consists of the value in the range through 0 to 9.

		pcfCmd.addParameter(MQConstants.MQIA_CLWL_Q_PRIORITY, wmqAliasQueue.getClwlQueuePriority());

		// Default persistent of the Alias Queue may be either Persistent or NonPersistent.

		if (WmqDefaultPersistence.PERSISTENT == wmqAliasQueue.getDefaultPersistence()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_PERSISTENCE, MQConstants.MQPER_PERSISTENT);
		} else if (WmqDefaultPersistence.NOT_PERSISTENT == wmqAliasQueue.getDefaultPersistence()) {

			pcfCmd.addParameter(MQConstants.MQIA_DEF_PERSISTENCE, MQConstants.MQPER_NOT_PERSISTENT);
		}

		// PutMessage option value may be either Allowed or Inhibited.

		if (WmqPutMessage.ALLOWED == wmqAliasQueue.getPutMessages()) {

			pcfCmd.addParameter(MQConstants.MQIA_INHIBIT_PUT, MQConstants.MQQA_PUT_ALLOWED);
		} else if (WmqPutMessage.INHIBITED == wmqAliasQueue.getPutMessages()) {

			pcfCmd.addParameter(MQConstants.MQIA_INHIBIT_PUT, MQConstants.MQQA_PUT_INHIBITED);
		}

		// Description of the Alias Queue.
		if (StringUtils.isNotBlank(wmqAliasQueue.getDescription())) {
			pcfCmd.addParameter(MQConstants.MQCA_Q_DESC, wmqAliasQueue.getDescription());

		}

		// Default Priority for Alias Queue.Assign the value through 0 to 9
		pcfCmd.addParameter(MQConstants.MQIA_DEF_PRIORITY, wmqAliasQueue.getDefaultPriority());

		// Scope of the Model queue.

		if (WmqScope.QUEUE_MANAGER == wmqAliasQueue.getScope()) {

			pcfCmd.addParameter(MQConstants.MQIA_SCOPE, MQConstants.MQSCO_Q_MGR);
		} else if (WmqScope.CELL == wmqAliasQueue.getScope()) {

			pcfCmd.addParameter(MQConstants.MQIA_SCOPE, MQConstants.MQSCO_CELL);
		}

		// DefaultBindType value may be either OnOpen or NotFixed.

		if (WmqDefaultBindType.ON_OPEN == wmqAliasQueue.getDefaultBindType()) {

			pcfCmd.addParameter(MQConstants.MQIA_DEF_BIND, MQConstants.MQBND_BIND_ON_OPEN);
		} else if (WmqDefaultBindType.NOT_FIXED == wmqAliasQueue.getDefaultBindType()) {

			pcfCmd.addParameter(MQConstants.MQIA_DEF_BIND, MQConstants.MQBND_BIND_NOT_FIXED);
		}

		// GetMessages value may be either Allowed or Inhibited.If no value is mentioned.

		if (WmqGetMessages.ALLOWED == wmqAliasQueue.getGetMessages()) {

			pcfCmd.addParameter(MQConstants.MQIA_INHIBIT_GET, MQConstants.MQQA_GET_ALLOWED);
		} else if (WmqGetMessages.INHIBITED == wmqAliasQueue.getGetMessages()) {

			pcfCmd.addParameter(MQConstants.MQIA_INHIBIT_GET, MQConstants.MQQA_GET_INHIBITED);
		}

		if (wmqAliasQueue.getClusterName() != null && wmqAliasQueue.getClusterNamelist() != null) {
			throw new MQPluginException("Clustername and Cluster Namelist both should not be given at a time in CI");
		}

		// ClusterName is the name of the cluster to which the queue belongs.

		if (StringUtils.isNotBlank((wmqAliasQueue.getClusterName()))) {
			pcfCmd.addParameter(MQConstants.MQCA_CLUSTER_NAME, wmqAliasQueue.getClusterName());
		}

		// ClusterNamelistName is the name of the namelist, that specifies a
		// list of clusters to which the queue belongs.

		if (StringUtils.isNotBlank(wmqAliasQueue.getClusterNamelist())) {
			pcfCmd.addParameter(MQConstants.MQCA_CLUSTER_NAMELIST, wmqAliasQueue.getClusterNamelist());
		}

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating AliasQueue \"" + wmqAliasQueue.getQueueName() + "\" on QueuManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
		}
		return "Creating AliasQueue Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The AliasQueue \"" + wmqAliasQueue.getQueueName() + "\" is created on QueueManager\"" + this.wmqQmanager.getQueueManagerName() + "\"";
	}

}
