/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.runbook;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Environment;

import com.xebialabs.deployit.plugin.wmq.ci.WmqResource;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqTarget;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqAliasQueueToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqClusterReceiverChannelToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqClusterSenderChannelToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqLU62ListenerToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqLocalQueueToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqModelQueueToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqNamelistToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqNetBIOSListenerToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqProcessDefinitionToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqReceiverChannelToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqRemoteQueueToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqRequesterChannelToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqSPXListenerToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqSenderChannelToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqServerChannelToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqServerConnectionChannelToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqSubscriptionsToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqTCPListenerToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqTopicToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.step.DisplayWmqCmdServerStatusStep;
import com.xebialabs.deployit.plugin.wmq.step.DisplayWmqQueueManagerStatusStep;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;

/**
 * Supports the deployment, re-deployment and undeployment of a {@link com.xebialabs.deployit.ci.DeploymentPackage Application Package} to a
 * {@link com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager WMQ QueueManager}.
 * 
 * <h4>Conditions</h4>
 * 
 * Will trigger if the change plan contains the addition, modification or deletion of a {@link Deployment Deployment} CI to an
 * {@link com.xebialabs.deployit.ci.Environment Environment} CI which contains WMQ middleware CI's.
 * 
 * <h4>Actions</h4>
 * 
 * Addition:
 * 
 * <ol>
 * <li>Deploy {@link WmqResource WebSphereMQ resources} in {@link WmqQueueManager WMQ QueueManager}
 * 
 * </ol>
 * 
 * Modify:
 * 
 * <ol>
 * <li>Modify {@link WmqResource WebSphereMQ resources} in {@link WmqQueueManager WMQ QueueManager}
 * 
 * </ol>
 * <p>
 * 
 * Deletion:
 * 
 * <ol>
 * <li>Undeploy {@link WmqResource WebSphereMQ resources} in {@link WmqQueueManager WMQ QueueManager}
 * </ol>
 */
public class WmqDeploymentRunBook extends SingleTypeHandlingRunBook<Deployment> {

	public WmqDeploymentRunBook() {
		super(Deployment.class);
	}

	protected void resolve(Change<Deployment> change, ChangePlan changePlan, List<Step> steps) {

		WmqSenderChannelToWmqQueueManagerMapper senderChannelToQueueManagerMapper = new WmqSenderChannelToWmqQueueManagerMapper(change);
		WmqReceiverChannelToWmqQueueManagerMapper receiverChannelToQueueManagerMapper = new WmqReceiverChannelToWmqQueueManagerMapper(change);
		WmqRequesterChannelToWmqQueueManagerMapper requesterChannelToQueueManagerMapper = new WmqRequesterChannelToWmqQueueManagerMapper(change);
		WmqServerChannelToWmqQueueManagerMapper serverChannelToQueueManagerMapper = new WmqServerChannelToWmqQueueManagerMapper(change);
		WmqServerConnectionChannelToWmqQueueManagerMapper serverConnectionChannelToQueueManagerMapper = new WmqServerConnectionChannelToWmqQueueManagerMapper(
		        change);
		WmqClusterSenderChannelToWmqQueueManagerMapper clusterSenderChannelToQueueManagerMapper = new WmqClusterSenderChannelToWmqQueueManagerMapper(change);
		WmqClusterReceiverChannelToWmqQueueManagerMapper clusterReceiverChannelToQueueManagerMapper = new WmqClusterReceiverChannelToWmqQueueManagerMapper(
		        change);

		WmqLocalQueueToWmqQueueManagerMapper localqToQmgrMapper = new WmqLocalQueueToWmqQueueManagerMapper(change);
		WmqAliasQueueToWmqQueueManagerMapper aliasqToQmgrMapper = new WmqAliasQueueToWmqQueueManagerMapper(change);
		WmqModelQueueToWmqQueueManagerMapper modelqToQmgrMapper = new WmqModelQueueToWmqQueueManagerMapper(change);
		WmqRemoteQueueToWmqQueueManagerMapper remoteqToQmgrMapper = new WmqRemoteQueueToWmqQueueManagerMapper(change);
		WmqProcessDefinitionToWmqQueueManagerMapper processToQmgrMapper = new WmqProcessDefinitionToWmqQueueManagerMapper(change);
		WmqNamelistToWmqQueueManagerMapper namelistToQmgrMapper = new WmqNamelistToWmqQueueManagerMapper(change);

		WmqTopicToWmqQueueManagerMapper topicToQueueManager = new WmqTopicToWmqQueueManagerMapper(change);
		WmqSubscriptionsToWmqQueueManagerMapper subscriptionsToQueueManager = new WmqSubscriptionsToWmqQueueManagerMapper(change);
		WmqTCPListenerToWmqQueueManagerMapper tcpListenerToQueueManager = new WmqTCPListenerToWmqQueueManagerMapper(change);
		WmqNetBIOSListenerToWmqQueueManagerMapper netbiosListenerToQueueManager = new WmqNetBIOSListenerToWmqQueueManagerMapper(change);
		WmqLU62ListenerToWmqQueueManagerMapper lu62ListenerToQueueManager = new WmqLU62ListenerToWmqQueueManagerMapper(change);
		WmqSPXListenerToWmqQueueManagerMapper spxListenerToQueueManager = new WmqSPXListenerToWmqQueueManagerMapper(change);

		if (!isMQDeployment(senderChannelToQueueManagerMapper, receiverChannelToQueueManagerMapper, serverChannelToQueueManagerMapper,
		        serverConnectionChannelToQueueManagerMapper, clusterSenderChannelToQueueManagerMapper, clusterReceiverChannelToQueueManagerMapper,
		        requesterChannelToQueueManagerMapper, localqToQmgrMapper, aliasqToQmgrMapper, modelqToQmgrMapper, remoteqToQmgrMapper, processToQmgrMapper,
		        namelistToQmgrMapper, topicToQueueManager, subscriptionsToQueueManager, tcpListenerToQueueManager, netbiosListenerToQueueManager,
		        lu62ListenerToQueueManager, spxListenerToQueueManager)) {
			return;
		}

		// check command server status

		Set<WmqQueueManager> queueManagerChanges = findWmqQueueManagerChangesForDeploymentChange(change);
		if (queueManagerChanges != null) {
			for (WmqQueueManager eachQueueManagerChange : queueManagerChanges) {

				// check Qmanager status
				steps.add(new DisplayWmqQueueManagerStatusStep(eachQueueManagerChange, true));

				// check CommandServer status
				steps.add(new DisplayWmqCmdServerStatusStep(eachQueueManagerChange, true));
			}
		}

		clusterSenderChannelToQueueManagerMapper.generateDeletionSteps(steps);
		clusterReceiverChannelToQueueManagerMapper.generateDeletionSteps(steps);
		requesterChannelToQueueManagerMapper.generateDeletionSteps(steps);
		serverChannelToQueueManagerMapper.generateDeletionSteps(steps);
		senderChannelToQueueManagerMapper.generateDeletionSteps(steps);
		receiverChannelToQueueManagerMapper.generateDeletionSteps(steps);
		serverConnectionChannelToQueueManagerMapper.generateDeletionSteps(steps);

		namelistToQmgrMapper.generateDeletionSteps(steps);
		processToQmgrMapper.generateDeletionSteps(steps);
		remoteqToQmgrMapper.generateDeletionSteps(steps);
		localqToQmgrMapper.generateDeletionSteps(steps);
		aliasqToQmgrMapper.generateDeletionSteps(steps);
		modelqToQmgrMapper.generateDeletionSteps(steps);

		topicToQueueManager.generateDeletionSteps(steps);
		subscriptionsToQueueManager.generateDeletionSteps(steps);
		tcpListenerToQueueManager.generateDeletionSteps(steps);
		netbiosListenerToQueueManager.generateDeletionSteps(steps);
		lu62ListenerToQueueManager.generateDeletionSteps(steps);
		spxListenerToQueueManager.generateDeletionSteps(steps);

		senderChannelToQueueManagerMapper.generateModificationSteps(steps);
		receiverChannelToQueueManagerMapper.generateModificationSteps(steps);
		requesterChannelToQueueManagerMapper.generateModificationSteps(steps);
		serverChannelToQueueManagerMapper.generateModificationSteps(steps);
		serverConnectionChannelToQueueManagerMapper.generateModificationSteps(steps);
		clusterSenderChannelToQueueManagerMapper.generateModificationSteps(steps);
		clusterReceiverChannelToQueueManagerMapper.generateModificationSteps(steps);

		namelistToQmgrMapper.generateModificationSteps(steps);
		processToQmgrMapper.generateModificationSteps(steps);
		remoteqToQmgrMapper.generateModificationSteps(steps);
		localqToQmgrMapper.generateModificationSteps(steps);
		aliasqToQmgrMapper.generateModificationSteps(steps);
		modelqToQmgrMapper.generateModificationSteps(steps);

		topicToQueueManager.generateModificationSteps(steps);
		subscriptionsToQueueManager.generateModificationSteps(steps);
		tcpListenerToQueueManager.generateModificationSteps(steps);
		netbiosListenerToQueueManager.generateModificationSteps(steps);
		lu62ListenerToQueueManager.generateModificationSteps(steps);
		spxListenerToQueueManager.generateModificationSteps(steps);

		topicToQueueManager.generateAdditionSteps(steps);
		subscriptionsToQueueManager.generateAdditionSteps(steps);
		tcpListenerToQueueManager.generateAdditionSteps(steps);
		netbiosListenerToQueueManager.generateAdditionSteps(steps);
		lu62ListenerToQueueManager.generateAdditionSteps(steps);
		spxListenerToQueueManager.generateAdditionSteps(steps);

		clusterReceiverChannelToQueueManagerMapper.generateAdditionSteps(steps);
		clusterSenderChannelToQueueManagerMapper.generateAdditionSteps(steps);
		serverChannelToQueueManagerMapper.generateAdditionSteps(steps);
		requesterChannelToQueueManagerMapper.generateAdditionSteps(steps);
		receiverChannelToQueueManagerMapper.generateAdditionSteps(steps);
		senderChannelToQueueManagerMapper.generateAdditionSteps(steps);
		serverConnectionChannelToQueueManagerMapper.generateAdditionSteps(steps);

		namelistToQmgrMapper.generateAdditionSteps(steps);
		processToQmgrMapper.generateAdditionSteps(steps);
		remoteqToQmgrMapper.generateAdditionSteps(steps);
		localqToQmgrMapper.generateAdditionSteps(steps);
		aliasqToQmgrMapper.generateAdditionSteps(steps);
		modelqToQmgrMapper.generateAdditionSteps(steps);

	}

	private boolean isMQDeployment(WmqSenderChannelToWmqQueueManagerMapper senderChannelToQueueManagerMapper,
	        WmqReceiverChannelToWmqQueueManagerMapper receiverChannelToQueueManagerMapper,
	        WmqServerChannelToWmqQueueManagerMapper serverChannelToQueueManagerMapper,
	        WmqServerConnectionChannelToWmqQueueManagerMapper serverConnectionChannelToQueueManagerMapper,
	        WmqClusterSenderChannelToWmqQueueManagerMapper clusterSenderChannelToQueueManagerMapper,
	        WmqClusterReceiverChannelToWmqQueueManagerMapper clusterReceiverChannelToQueueManagerMapper,
	        WmqRequesterChannelToWmqQueueManagerMapper requesterChannelToQueueManagerMapper, WmqLocalQueueToWmqQueueManagerMapper localqToQmgrMapper,
	        WmqAliasQueueToWmqQueueManagerMapper aliasqToQmgrMapper, WmqModelQueueToWmqQueueManagerMapper modelqToQmgrMapper,
	        WmqRemoteQueueToWmqQueueManagerMapper remoteqToQmgrMapper, WmqProcessDefinitionToWmqQueueManagerMapper processToQmgrMapper,
	        WmqNamelistToWmqQueueManagerMapper namelistToQmgrMapper, WmqTopicToWmqQueueManagerMapper topicToQueueManager,
	        WmqSubscriptionsToWmqQueueManagerMapper subscriptionsToQueueManager, WmqTCPListenerToWmqQueueManagerMapper tcpListenerToQueueManager,
	        WmqNetBIOSListenerToWmqQueueManagerMapper netbiosListenerToQueueManager, WmqLU62ListenerToWmqQueueManagerMapper lu62ListenerToQueueManager,
	        WmqSPXListenerToWmqQueueManagerMapper spxListenerToQueueManager) {

		Set<WmqTarget> affectedQueueManager = new HashSet<WmqTarget>();
		affectedQueueManager.addAll(senderChannelToQueueManagerMapper.getAffectedTargets());
		affectedQueueManager.addAll(receiverChannelToQueueManagerMapper.getAffectedTargets());
		affectedQueueManager.addAll(requesterChannelToQueueManagerMapper.getAffectedTargets());
		affectedQueueManager.addAll(serverChannelToQueueManagerMapper.getAffectedTargets());
		affectedQueueManager.addAll(serverConnectionChannelToQueueManagerMapper.getAffectedTargets());
		affectedQueueManager.addAll(clusterSenderChannelToQueueManagerMapper.getAffectedTargets());
		affectedQueueManager.addAll(clusterReceiverChannelToQueueManagerMapper.getAffectedTargets());
		affectedQueueManager.addAll(localqToQmgrMapper.getAffectedTargets());
		affectedQueueManager.addAll(aliasqToQmgrMapper.getAffectedTargets());
		affectedQueueManager.addAll(modelqToQmgrMapper.getAffectedTargets());
		affectedQueueManager.addAll(remoteqToQmgrMapper.getAffectedTargets());
		affectedQueueManager.addAll(processToQmgrMapper.getAffectedTargets());
		affectedQueueManager.addAll(namelistToQmgrMapper.getAffectedTargets());

		affectedQueueManager.addAll(topicToQueueManager.getAffectedTargets());
		affectedQueueManager.addAll(subscriptionsToQueueManager.getAffectedTargets());
		affectedQueueManager.addAll(tcpListenerToQueueManager.getAffectedTargets());
		affectedQueueManager.addAll(netbiosListenerToQueueManager.getAffectedTargets());
		affectedQueueManager.addAll(lu62ListenerToQueueManager.getAffectedTargets());
		affectedQueueManager.addAll(spxListenerToQueueManager.getAffectedTargets());

		return !(affectedQueueManager.isEmpty());

	}

	private Set<WmqQueueManager> findWmqQueueManagerChangesForDeploymentChange(Change<Deployment> deploymentChange) {
		return getQueueManagerDeploymentTarget(deploymentChange.getNewRevision());
	}

	private Set<WmqQueueManager> getQueueManagerDeploymentTarget(Deployment deployment) {

		Set<WmqQueueManager> queueManagerChanges = null;
		if (deployment != null) {
			Environment env = deployment.getTarget();
			queueManagerChanges = env.getMembersOfType(WmqQueueManager.class);

		}
		return queueManagerChanges;

	}
}
