/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import java.util.Map;

import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "Listener objects are used to accept incoming network requests from remote queue managers, or client applications. Once accepted, a listener starts the associated receiver or server connection channels to allow the queue manager to receive messages.")
public class WmqTCPListener extends WmqListener implements Discoverable<WmqTCPListener> {

	@ConfigurationItemProperty(label = "Port", description = "The port number for TCP/IP.")
	private int port;

	@ConfigurationItemProperty(label = "IP address", description = "")
	private String ipAddress;

	@ConfigurationItemProperty(label = "Backlog", description = "The number of concurrent connection requests that the listener supports.")
	private int backlog;

	@ConfigurationItemProperty(label = "Queue Manager", description = "Queue Manager on which TCP Listener is Discovered ,Value used only in discovery ", size = Size.LARGE, identifying = true)
	private WmqQueueManager wmqQueueManager;

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public String getIpAddress() {
		return ipAddress;
	}

	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	public int getBacklog() {
		return backlog;
	}

	public void setBacklog(int backlog) {
		this.backlog = backlog;
	}

	public WmqQueueManager getWmqQueueManager() {
		return wmqQueueManager;
	}

	public void setWmqQueueManager(WmqQueueManager wmqQueueManager) {
		this.wmqQueueManager = wmqQueueManager;
	}

	public WmqTCPListener discover(Map<String, Object> info, ChangePlan cp) {
		return null;
	}

	public WmqTCPListener discoverChildrenInfo(Map<String, Object> discoveredAdditionalInfo, ChangePlan cp) {

		return null;
	}
}
