/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "The MQSvrConnChannel class represents an individual server connection channel on a particular queue manager. Enumerating an object of this class results in an empty list.")
public class WmqServerConnectionChannel extends WmqBaseServerConnectionChannel {

	@ConfigurationItemProperty(required = false, label = "MQ Version", description = "Specify type of MQ Version")
	private WmqVersion version;

	@ConfigurationItemProperty(label = "Maximum instances", description = "Maximum number of simultaneous instances of a server-connection channel.Specify a value in the range 0 to 999 999 999.", category = "Extended")
	private int maximumInstances = 999999999;

	@ConfigurationItemProperty(label = "Maximum instances per client", description = "Maximum number of simultaneous instances of a server-connection channel that can be started from a single client.Specify a value in the range 0 to 999 999 999. ", category = "Extended")
	private int maximumInstancesPerClient = 999999999;

	@ConfigurationItemProperty(label = "Sharing conversations", description = "Specifies the maximum number of conversations that can share a particular TCP/IP MQI channel instance (socket).Specify a value in the range 0 to 999 999 999.", category = "Extended")
	private int sharingConversations = 10;

	public WmqVersion getVersion() {
		return version;
	}

	public int getMaximumInstances() {
		return maximumInstances;
	}

	public void setMaximumInstances(int maximumInstances) {
		this.maximumInstances = maximumInstances;
	}

	public int getMaximumInstancesPerClient() {
		return maximumInstancesPerClient;
	}

	public void setMaximumInstancesPerClient(int maximumInstancesPerClient) {
		this.maximumInstancesPerClient = maximumInstancesPerClient;
	}

	public int getSharingConversations() {
		return sharingConversations;
	}

	public void setSharingConversations(int sharingConversations) {
		this.sharingConversations = sharingConversations;
	}

}
