/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPersistence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPutMessage;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "A Websphre MQ queue consists of common properties of model,local,alias and remote queues")
public abstract class WmqQueue extends BaseConfigurationItem implements WmqResource {

	@ConfigurationItemProperty(required = true, label = "Queue name", identifying = true, description = "Name of the Queue eg.,Q1,flower etc")
	private String queueName;

	@ConfigurationItemProperty(label = "QueuePersistent", description = "We can set the persistence property.If you select NO then msg's will lost when Queuemanager restart.If you select YES messages won't loss even though the Queuemanager restarts)")
	private WmqDefaultPersistence defaultPersistence;

	@ConfigurationItemProperty(label = "QueueDescription ", description = "This provides descriptive information about the object when an operator issues the DISPLAY QUEUE command")
	private String description;

	@ConfigurationItemProperty(label = "QueuePriority ", description = "The default priority of messages put on the queue.The Priority ranges from 0(lowest prty)  to  9(max prty)We can set Priority for queue in the range 0 to 9")
	private int defaultPriority;

	@ConfigurationItemProperty(label = "PutMessages", description = "We can specify that whether we can put message on queue or not.We can specify this by choosing either put_Allowed or put_Inhibited options")
	private WmqPutMessage putMessages;

	public String getQueueName() {
		return queueName;
	}

	public void setQueueName(String queueName) {
		this.queueName = queueName;
	}

	public WmqDefaultPersistence getDefaultPersistence() {
		return defaultPersistence;
	}

	public void setDefaultPersistence(WmqDefaultPersistence defaultPersistence) {
		this.defaultPersistence = defaultPersistence;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public int getDefaultPriority() {
		return defaultPriority;
	}

	public void setDefaultPriority(int defaultPriority) {
		this.defaultPriority = defaultPriority;
	}

	public WmqPutMessage getPutMessages() {
		return putMessages;
	}

	public void setPutMessages(WmqPutMessage putMessages) {
		this.putMessages = putMessages;
	}

}