/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultInputOpenOption;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultReadAhead;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefinitionType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDistributionLists;
import com.xebialabs.deployit.plugin.wmq.enums.WmqGetMessages;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHardengetBackout;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMessageDeliverySequence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNPMClass;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueAccounting;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthHighEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthLowEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthMaxEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueServiceIntervalEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueStatistics;
import com.xebialabs.deployit.plugin.wmq.enums.WmqShareability;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTriggerControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTriggerType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqUsage;

@SuppressWarnings("serial")
public abstract class WmqBaseModelQueue extends WmqQueue {

	@ConfigurationItemProperty(label = "GetMessages", description = "We can specify that whether we can get message on queue or not.We can specify this by choosing either get_Allowed or get_Inhibited options")
	private WmqGetMessages getMessages;

	@ConfigurationItemProperty(label = "Usage", description = "We have to specify whether the Queue is Normal or a Transmit Queue")
	private WmqUsage usage;

	@ConfigurationItemProperty(label = "Max Queue Depth", description = "We can specify maximum depth of the queue in the range zero through 999 999 999  ", category = "Extended")
	private int maxQueueDepth = 5000;

	@ConfigurationItemProperty(label = "Max Message Length", description = "The maximum length (in bytes) of messages on this queue.Specify a value in the range zero through to the maximum message length for the QueueManager ", category = "Extended")
	private int maxMessageLength = 4194304;

	@ConfigurationItemProperty(label = "Default Input Open Option", description = " Specifies the default share option for applications opening this queue for input.", category = "Extended")
	private WmqDefaultInputOpenOption defaultInputOpenOption;

	@ConfigurationItemProperty(label = "Shareability", description = " We can specify the shareability of the queue by setting the options SHARE or NOSHARE", category = "Extended")
	private WmqShareability shareability;

	@ConfigurationItemProperty(label = "Message Delivery Sequence", description = "We can specify the sequence of msg's in the queue by two options.", category = "Extended")
	private WmqMessageDeliverySequence messageDeliverySequence;

	@ConfigurationItemProperty(label = "Retention Interval", description = "We can specify the number of hours for which the queue might be needed.The value should be in the range 0 through 999 999 999.", category = "Extended")
	private int retentionInterval = 999999999;

	@ConfigurationItemProperty(label = "Defifnition Type", description = "Specify the queue definition type whether it is Temporary or permanent", category = "Extended")
	private WmqDefinitionType defifnitionType;

	@ConfigurationItemProperty(label = "Distribution Lists", description = "We can specify whether distribution-list messages can be placed on the queue.", category = "Extended")
	private WmqDistributionLists distributionLists;

	@ConfigurationItemProperty(label = "Default read ahead", description = "We can specify the DEFAULT READ AHEAD option for a queue.by setting the options YES or NO or DISABLED ", category = "Extended")
	private WmqDefaultReadAhead defaultReadAhead;

	@ConfigurationItemProperty(label = "Trigger Control", description = "Specify whether trigger messages are written to the initiation queue.", category = "Triggering")
	private WmqTriggerControl triggerControl;

	@ConfigurationItemProperty(label = "Trigger Type", description = "Specify the condition that initiates a trigger event. When the condition is true, a trigger message is sent to the initiation queue.", category = "Triggering")
	private WmqTriggerType triggerType;

	@ConfigurationItemProperty(label = "Trigger Depth", description = "Specify (when TriggerType is MQTT_DEPTH) the number of messages that will initiate a trigger message to the initiation queue.", category = "Triggering")
	private int triggerDepth = 1;

	@ConfigurationItemProperty(label = "Trigger Message Priority", description = "Specify the minimum priority that a message must have before it can cause, or be counted for, a trigger event.The value must be 0 to 9 ", category = "Triggering")
	private int triggerMessagePriority;

	@ConfigurationItemProperty(label = "Trigger Data", description = "Specify user data that the queue manager includes in the trigger message.The maximum length of the string is MQ_TRIGGER_DATA_LENGTH. This data is made available to the monitoring application that processes the initiation queue and to the application that is started by the monitor.", category = "Triggering")
	private String triggerData;

	@ConfigurationItemProperty(label = "Initiation Queue", description = "The local queue for trigger messages relating to this queue. The initiation queue must be on the same queue manager.", category = "Triggering")
	private String initiationQueue;

	@ConfigurationItemProperty(label = "process name", description = "Specify the local name of the WebSphere MQ process that identifies the application to be started when a trigger event occurs. ", category = "Triggering")
	private String processName;

	@ConfigurationItemProperty(label = "Queue Depth Max Events", description = "Specify the whether Queue Full events to be generated or not ", category = "Events")
	private WmqQueueDepthMaxEvents queueDepthMaxEvents;

	@ConfigurationItemProperty(label = "Queue Depth High Events", description = "Controls whether Queue Depth High events are generated.", category = "Events")
	private WmqQueueDepthHighEvents queueDepthHighEvents;

	@ConfigurationItemProperty(label = "Queue Depth High Limit", description = "This event indicates that an application has put a message to a queue.The value must be greater than or equal to zero and less than or equal to 100. ", category = "Events")
	private int queueDepthHighLimit = 80;

	@ConfigurationItemProperty(label = "Queue Depth Low Limit", description = "This event indicates that an application has retrieved a message from a queue, and this has caused the number of messages on the queue to become less than or equal to the queue depth low threshold. ", category = "Events")
	private int queueDepthLowLimit = 20;

	@ConfigurationItemProperty(label = "Queue Depth Low Events", description = "A Queue Depth Low event indicates that an application has retrieved a message from a queue, and this has caused the number of messages on the queue to become less than or equal to the queue depth low threshold.", category = "Events")
	private WmqQueueDepthLowEvents queueDepthLowEvents;

	@ConfigurationItemProperty(label = "Queue Service Interval Events", description = "Controls whether Service Interval High or Service Interval OK events are generated or not ", category = "Events")
	private WmqQueueServiceIntervalEvents queueServiceIntervalEvents;

	@ConfigurationItemProperty(label = "Queue Service Interval", description = "The service interval used for comparison to generate Queue Service Interval High and Queue Service Interval OK events. ", category = "Events")
	private int queueServiceInterval = 999999999;

	@ConfigurationItemProperty(label = "Backout Requeue Queue", description = "Specifies the local name of the queue (not necessarily a local queue) to which a message is transferred if it is backed out more times than the value of BackoutThreshold.", category = "Storage")
	private String backoutRequeueQueue;

	@ConfigurationItemProperty(label = " Backout Threshold", description = "The number of times a message can be backed out before it is transferred to the backout queue specified by BackoutRequeueName. ", category = "Storage")
	private int backoutThreshold;

	@ConfigurationItemProperty(label = " Harden get Backout", description = " Specifies whether the count of backed out messages is saved (hardened) across restarts of the message queue manager. ", category = "Storage")
	private WmqHardengetBackout hardengetBackout;

	@ConfigurationItemProperty(label = " NPM Class", description = "The level of reliability to be assigned to non-persistent messages that are put to the queue ", category = "Storage")
	private WmqNPMClass npmClass;

	@ConfigurationItemProperty(label = "Queue Monitoring", description = "Specify whether online monitoring data is to be collected and, if so, the rate at which the data is collected.", category = "Statistics")
	private WmqQueueMonitoring queueMonitoring;

	@ConfigurationItemProperty(label = "Queue Statistics", description = "Specify whether statistics data collection is enabled or not.", category = "Statistics")
	private WmqQueueStatistics queueStatistics;

	@ConfigurationItemProperty(label = "Queue Accounting", description = "Controls the collection of accounting data", category = "Statistics")
	private WmqQueueAccounting queueAccounting;

	public WmqGetMessages getGetMessages() {
		return getMessages;
	}

	public void setGetMessages(WmqGetMessages getMessages) {
		this.getMessages = getMessages;
	}

	public WmqUsage getUsage() {
		return usage;
	}

	public void setUsage(WmqUsage usage) {
		this.usage = usage;
	}

	public int getMaxQueueDepth() {
		return maxQueueDepth;
	}

	public void setMaxQueueDepth(int maxQueueDepth) {
		this.maxQueueDepth = maxQueueDepth;
	}

	public int getMaxMessageLength() {
		return maxMessageLength;
	}

	public void setMaxMessageLength(int maxMessageLength) {
		this.maxMessageLength = maxMessageLength;
	}

	public WmqDefaultInputOpenOption getDefaultInputOpenOption() {
		return defaultInputOpenOption;
	}

	public void setDefaultInputOpenOption(WmqDefaultInputOpenOption defaultInputOpenOption) {
		this.defaultInputOpenOption = defaultInputOpenOption;
	}

	public WmqShareability getShareability() {
		return shareability;
	}

	public void setShareability(WmqShareability shareability) {
		this.shareability = shareability;
	}

	public WmqMessageDeliverySequence getMessageDeliverySequence() {
		return messageDeliverySequence;
	}

	public void setMessageDeliverySequence(WmqMessageDeliverySequence messageDeliverySequence) {
		this.messageDeliverySequence = messageDeliverySequence;
	}

	public int getRetentionInterval() {
		return retentionInterval;
	}

	public void setRetentionInterval(int retentionInterval) {
		this.retentionInterval = retentionInterval;
	}

	public WmqDefinitionType getDefifnitionType() {
		return defifnitionType;
	}

	public void setDefifnitionType(WmqDefinitionType defifnitionType) {
		this.defifnitionType = defifnitionType;
	}

	public WmqDistributionLists getDistributionLists() {
		return distributionLists;
	}

	public void setDistributionLists(WmqDistributionLists distributionLists) {
		this.distributionLists = distributionLists;
	}

	public WmqDefaultReadAhead getDefaultReadAhead() {
		return defaultReadAhead;
	}

	public void setDefaultReadAhead(WmqDefaultReadAhead defaultReadAhead) {
		this.defaultReadAhead = defaultReadAhead;
	}

	public WmqTriggerControl getTriggerControl() {
		return triggerControl;
	}

	public void setTriggerControl(WmqTriggerControl triggerControl) {
		this.triggerControl = triggerControl;
	}

	public WmqTriggerType getTriggerType() {
		return triggerType;
	}

	public void setTriggerType(WmqTriggerType triggerType) {
		this.triggerType = triggerType;
	}

	public int getTriggerDepth() {
		return triggerDepth;
	}

	public void setTriggerDepth(int triggerDepth) {
		this.triggerDepth = triggerDepth;
	}

	public int getTriggerMessagePriority() {
		return triggerMessagePriority;
	}

	public void setTriggerMessagePriority(int triggerMessagePriority) {
		this.triggerMessagePriority = triggerMessagePriority;
	}

	public String getTriggerData() {
		return triggerData;
	}

	public void setTriggerData(String triggerData) {
		this.triggerData = triggerData;
	}

	public String getInitiationQueue() {
		return initiationQueue;
	}

	public void setInitiationQueue(String initiationQueue) {
		this.initiationQueue = initiationQueue;
	}

	public String getProcessName() {
		return processName;
	}

	public void setProcessName(String processName) {
		this.processName = processName;
	}

	public WmqQueueDepthMaxEvents getQueueDepthMaxEvents() {
		return queueDepthMaxEvents;
	}

	public void setQueueDepthMaxEvents(WmqQueueDepthMaxEvents queueDepthMaxEvents) {
		this.queueDepthMaxEvents = queueDepthMaxEvents;
	}

	public WmqQueueDepthHighEvents getQueueDepthHighEvents() {
		return queueDepthHighEvents;
	}

	public void setQueueDepthHighEvents(WmqQueueDepthHighEvents queueDepthHighEvents) {
		this.queueDepthHighEvents = queueDepthHighEvents;
	}

	public int getQueueDepthHighLimit() {
		return queueDepthHighLimit;
	}

	public void setQueueDepthHighLimit(int queueDepthHighLimit) {
		this.queueDepthHighLimit = queueDepthHighLimit;
	}

	public int getQueueDepthLowLimit() {
		return queueDepthLowLimit;
	}

	public void setQueueDepthLowLimit(int queueDepthLowLimit) {
		this.queueDepthLowLimit = queueDepthLowLimit;
	}

	public WmqQueueDepthLowEvents getQueueDepthLowEvents() {
		return queueDepthLowEvents;
	}

	public void setQueueDepthLowEvents(WmqQueueDepthLowEvents queueDepthLowEvents) {
		this.queueDepthLowEvents = queueDepthLowEvents;
	}

	public WmqQueueServiceIntervalEvents getQueueServiceIntervalEvents() {
		return queueServiceIntervalEvents;
	}

	public void setQueueServiceIntervalEvents(WmqQueueServiceIntervalEvents queueServiceIntervalEvents) {
		this.queueServiceIntervalEvents = queueServiceIntervalEvents;
	}

	public int getQueueServiceInterval() {
		return queueServiceInterval;
	}

	public void setQueueServiceInterval(int queueServiceInterval) {
		this.queueServiceInterval = queueServiceInterval;
	}

	public String getBackoutRequeueQueue() {
		return backoutRequeueQueue;
	}

	public void setBackoutRequeueQueue(String backoutRequeueQueue) {
		this.backoutRequeueQueue = backoutRequeueQueue;
	}

	public int getBackoutThreshold() {
		return backoutThreshold;
	}

	public void setBackoutThreshold(int backoutThreshold) {
		this.backoutThreshold = backoutThreshold;
	}

	public WmqHardengetBackout getHardengetBackout() {
		return hardengetBackout;
	}

	public void setHardengetBackout(WmqHardengetBackout hardengetBackout) {
		this.hardengetBackout = hardengetBackout;
	}

	public WmqNPMClass getNpmClass() {
		return npmClass;
	}

	public void setNpmClass(WmqNPMClass npmClass) {
		this.npmClass = npmClass;
	}

	public WmqQueueMonitoring getQueueMonitoring() {
		return queueMonitoring;
	}

	public void setQueueMonitoring(WmqQueueMonitoring queueMonitoring) {
		this.queueMonitoring = queueMonitoring;
	}

	public WmqQueueStatistics getQueueStatistics() {
		return queueStatistics;
	}

	public void setQueueStatistics(WmqQueueStatistics queueStatistics) {
		this.queueStatistics = queueStatistics;
	}

	public WmqQueueAccounting getQueueAccounting() {
		return queueAccounting;
	}

	public void setQueueAccounting(WmqQueueAccounting queueAccounting) {
		this.queueAccounting = queueAccounting;
	}

}
