/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqServerChannel;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMCAType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDataConversion;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonpersistentMessageSpeed;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSSLClientAuthentication;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

public class CreateWmqServerChannelStep
extends BaseWmqStep {
    public WmqServerChannel wmqServerChannel;
    private int[] messageCompressionList = new int[1];

    public CreateWmqServerChannelStep(WmqServerChannel wmqServerChannel, WmqQueueManager wmqQmanager) {
        this.wmqServerChannel = wmqServerChannel;
        this.wmqQmanager = wmqQmanager;
    }

    protected void init() {
        this.mqCommand = 23;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        int[] list;
        pcfCmd.addParameter(3501, this.wmqServerChannel.getChannelName());
        pcfCmd.addParameter(1511, 2);
        if (StringUtils.isNotBlank(this.wmqServerChannel.getDescription())) {
            pcfCmd.addParameter(3502, this.wmqServerChannel.getDescription());
        }
        if (WmqTransmissionProtocolTypes.LU6 == this.wmqServerChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 1);
        } else if (WmqTransmissionProtocolTypes.NET_BIOS == this.wmqServerChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 3);
        } else if (WmqTransmissionProtocolTypes.SPX == this.wmqServerChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 4);
        } else {
            pcfCmd.addParameter(1501, 2);
        }
        if (StringUtils.isNotBlank(this.wmqServerChannel.getConnectionName())) {
            pcfCmd.addParameter(3506, this.wmqServerChannel.getConnectionName());
        }
        pcfCmd.addParameter(3505, this.wmqServerChannel.getTransmissionQueue());
        if (StringUtils.isNotBlank(this.wmqServerChannel.getLocalCommunicationAddress())) {
            pcfCmd.addParameter(3520, this.wmqServerChannel.getLocalCommunicationAddress());
        }
        if (WmqHeaderCompression.SYSTEM == this.wmqServerChannel.getHeaderCompression()) {
            list = new int[]{8};
            pcfCmd.addParameter(1575, list);
        } else {
            list = new int[]{0};
            pcfCmd.addParameter(1575, list);
        }
        pcfCmd.addParameter(1563, this.wmqServerChannel.getHeartBeatInterval());
        if (this.wmqServerChannel.getKeepAliveInterval() > -1 && this.wmqServerChannel.getKeepAliveInterval() <= 99999) {
            pcfCmd.addParameter(1566, this.wmqServerChannel.getKeepAliveInterval());
        }
        pcfCmd.addParameter(1510, this.wmqServerChannel.getMaximumMessageLength());
        if (this.wmqServerChannel.getSequenceNumberWrap() < 100) {
            pcfCmd.addParameter(1509, 999999999);
        } else if (this.wmqServerChannel.getSequenceNumberWrap() != 0) {
            pcfCmd.addParameter(1509, this.wmqServerChannel.getSequenceNumberWrap());
        }
        if (WmqMessageCompression.RLE == this.wmqServerChannel.getMessageCompression()) {
            this.messageCompressionList[0] = 1;
            pcfCmd.addParameter(1576, this.messageCompressionList);
        } else if (WmqMessageCompression.ZLIBFAST == this.wmqServerChannel.getMessageCompression()) {
            this.messageCompressionList[0] = 2;
            pcfCmd.addParameter(1576, this.messageCompressionList);
        } else if (WmqMessageCompression.ZLIBHIGH == this.wmqServerChannel.getMessageCompression()) {
            this.messageCompressionList[0] = 4;
            pcfCmd.addParameter(1576, this.messageCompressionList);
        } else {
            this.messageCompressionList[0] = 0;
            pcfCmd.addParameter(1576, this.messageCompressionList);
        }
        if (WmqNonpersistentMessageSpeed.NORMAL == this.wmqServerChannel.getNonPersistentMessageSpeed()) {
            pcfCmd.addParameter(1562, 1);
        } else {
            pcfCmd.addParameter(1562, 2);
        }
        pcfCmd.addParameter(1502, this.wmqServerChannel.getBatchSize());
        pcfCmd.addParameter(1564, this.wmqServerChannel.getBatchInterval());
        pcfCmd.addParameter(1503, this.wmqServerChannel.getDisconnectInterval());
        if (WmqDataConversion.CONVERSION == this.wmqServerChannel.getDataConversion()) {
            pcfCmd.addParameter(1515, 1);
        } else {
            pcfCmd.addParameter(1515, 0);
        }
        pcfCmd.addParameter(1567, this.wmqServerChannel.getBatchHeartBeatInterval());
        if (this.wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
            if (WmqChannelPropertyControl.ALL == this.wmqServerChannel.getPropertyControl()) {
                pcfCmd.addParameter(190, 2);
            } else if (WmqChannelPropertyControl.NONE == this.wmqServerChannel.getPropertyControl()) {
                pcfCmd.addParameter(190, 1);
            } else {
                pcfCmd.addParameter(190, 0);
            }
        }
        if (StringUtils.isNotBlank(this.wmqServerChannel.getMcaUserID())) {
            pcfCmd.addParameter(3527, this.wmqServerChannel.getMcaUserID());
        }
        if (WmqChannelMCAType.THREAD == this.wmqServerChannel.getMcaType()) {
            pcfCmd.addParameter(1517, 2);
        } else {
            pcfCmd.addParameter(1517, 1);
        }
        if (StringUtils.isNotBlank(this.wmqServerChannel.getSendExit())) {
            String[] sendExitList = StringUtils.split(this.wmqServerChannel.getSendExit(), ",");
            pcfCmd.addParameter(3510, sendExitList);
        }
        if (StringUtils.isNotBlank(this.wmqServerChannel.getSendExitUserData())) {
            String[] sendExitUserDataList = StringUtils.split(this.wmqServerChannel.getSendExitUserData(), ",");
            pcfCmd.addParameter(3515, sendExitUserDataList);
        }
        if (StringUtils.isNotBlank(this.wmqServerChannel.getReceiveExit())) {
            String[] receiveExitList = StringUtils.split(this.wmqServerChannel.getReceiveExit(), ",");
            pcfCmd.addParameter(3511, receiveExitList);
        }
        if (StringUtils.isNotBlank(this.wmqServerChannel.getReceiveExitUserData())) {
            String[] receiveExitUserDataList = StringUtils.split(this.wmqServerChannel.getReceiveExitUserData(), ",");
            pcfCmd.addParameter(3516, receiveExitUserDataList);
        }
        if (StringUtils.isNotBlank(this.wmqServerChannel.getSecurityExit())) {
            pcfCmd.addParameter(3508, this.wmqServerChannel.getSecurityExit());
        }
        if (StringUtils.isNotBlank(this.wmqServerChannel.getSecurityExitUserData())) {
            pcfCmd.addParameter(3513, this.wmqServerChannel.getSecurityExitUserData());
        }
        if (StringUtils.isNotBlank(this.wmqServerChannel.getMessageExitName())) {
            String[] messageExitList = StringUtils.split(this.wmqServerChannel.getMessageExitName(), ",");
            pcfCmd.addParameter(3509, messageExitList);
        }
        if (StringUtils.isNotBlank(this.wmqServerChannel.getMessageExitUserData())) {
            String[] messageExitUserList = StringUtils.split(this.wmqServerChannel.getMessageExitUserData(), ",");
            pcfCmd.addParameter(3514, messageExitUserList);
        }
        pcfCmd.addParameter(1505, this.wmqServerChannel.getShortRetryCount());
        pcfCmd.addParameter(1504, this.wmqServerChannel.getShortRetryInterval());
        pcfCmd.addParameter(1507, this.wmqServerChannel.getLongRetryCount());
        pcfCmd.addParameter(1506, this.wmqServerChannel.getLongRetryInterval());
        if (WmqChannelMonitoring.HIGH == this.wmqServerChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 65);
        } else if (WmqChannelMonitoring.LOW == this.wmqServerChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 17);
        } else if (WmqChannelMonitoring.MEDIUM == this.wmqServerChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 33);
        } else if (WmqChannelMonitoring.OFF == this.wmqServerChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 0);
        } else {
            pcfCmd.addParameter(122, -3);
        }
        if (WmqChannelStatisticTypes.HIGH == this.wmqServerChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 65);
        } else if (WmqChannelStatisticTypes.LOW == this.wmqServerChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 17);
        } else if (WmqChannelStatisticTypes.MEDIUM == this.wmqServerChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 33);
        } else if (WmqChannelStatisticTypes.OFF == this.wmqServerChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 0);
        } else {
            pcfCmd.addParameter(129, -3);
        }
        if (this.wmqServerChannel.getSslCipherSpecification() != null) {
            pcfCmd.addParameter(3544, this.wmqServerChannel.getSslCipherSpecification().toString());
        }
        if (WmqSSLClientAuthentication.OPTIONAL == this.wmqServerChannel.getSslClientAuth()) {
            pcfCmd.addParameter(1568, 1);
        } else {
            pcfCmd.addParameter(1568, 0);
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating ServerChannel \"" + this.wmqServerChannel.getChannelName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating ServerChannel Step";
    }

    protected String getSuccessMessage() {
        return "The ServerChannel \"" + this.wmqServerChannel.getChannelName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

