/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqTopic;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;

/**
 * Destroys a {@link WmqTopic} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class DestroyWmqTopicStep extends BaseWmqStep {

	private WmqTopic wmqTopic;

	public DestroyWmqTopicStep(WmqTopic wmqTopic, WmqQueueManager wmqQmanager) {

		this.wmqTopic = wmqTopic;

		this.wmqQmanager = wmqQmanager;
	}

	@Override
	protected void init() {
		if (wmqQmanager.getVersion() == WmqVersion.WMQ_60) {

			throw new ResolutionException("Topic is not supported in MQV6");
		}
		this.mqCommand = MQConstants.MQCMD_DELETE_TOPIC;

	}

	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		// topic name - Mandatory.
		pcfCmd.addParameter(MQConstants.MQCA_TOPIC_NAME, wmqTopic.getTopicName());

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Deleting Topic \"" + wmqTopic.getTopicName() + "\" from QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
		}
		return "Deleting Topic with PCF";
	}

	@Override
	protected String getSuccessMessage() {

		return "The Topic \"" + wmqTopic.getTopicName() + "\" is deleted from QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";

	}

}
