/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;

import com.xebialabs.deployit.plugin.wmq.ci.WmqLocalQueue;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqCLWLUseQueue;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultBindType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultInputOpenOption;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPersistence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPutResponseType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultReadAhead;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDistributionLists;
import com.xebialabs.deployit.plugin.wmq.enums.WmqGetMessages;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHardengetBackout;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMessageDeliverySequence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNPMClass;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPutMessage;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueAccounting;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthHighEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthLowEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthMaxEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueServiceIntervalEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueStatistics;
import com.xebialabs.deployit.plugin.wmq.enums.WmqScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqShareability;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTriggerControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTriggerType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqUsage;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.utils.MQPluginException;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

/**
 * Creates a {@link WmqLocalQueue} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqLocalQueueStep extends BaseWmqStep {

	public WmqLocalQueue wmqLocalQueue;

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_CREATE_Q;

	}

	public CreateWmqLocalQueueStep(WmqLocalQueue wmqLocalQueue, WmqQueueManager wmqQmanager) {

		this.wmqLocalQueue = wmqLocalQueue;
		this.wmqQmanager = wmqQmanager;
	}

	public void setPCFMessageParameters(PCFMessage pcfCmd) throws MQPluginException {

		// Local Queue name - Mandatory.
		pcfCmd.addParameter(MQConstants.MQCA_Q_NAME, wmqLocalQueue.getQueueName());

		// Queue Type - Optional.This is mentioned here itself
		pcfCmd.addParameter(MQConstants.MQIA_Q_TYPE, MQConstants.MQQT_LOCAL);

		// Default persistent of the Local Queue may be either Persistent or NotPersistent.

		if (WmqDefaultPersistence.PERSISTENT == wmqLocalQueue.getDefaultPersistence()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_PERSISTENCE, MQConstants.MQPER_PERSISTENT);
		} else if (WmqDefaultPersistence.NOT_PERSISTENT == wmqLocalQueue.getDefaultPersistence()) {

			pcfCmd.addParameter(MQConstants.MQIA_DEF_PERSISTENCE, MQConstants.MQPER_NOT_PERSISTENT);
		}

		// Scope of the Local queue.

		if (WmqScope.QUEUE_MANAGER == wmqLocalQueue.getScope()) {

			pcfCmd.addParameter(MQConstants.MQIA_SCOPE, MQConstants.MQSCO_Q_MGR);
		} else if (WmqScope.CELL == wmqLocalQueue.getScope()) {

			pcfCmd.addParameter(MQConstants.MQIA_SCOPE, MQConstants.MQSCO_CELL);
		}

		// CLWLqueuerank consists of the value in the range through 0 to 9.
		pcfCmd.addParameter(MQConstants.MQIA_CLWL_Q_RANK, wmqLocalQueue.getClwlQueueRank());

		// CLWLqueuepriority consists of the value in the range through 0 to 9.
		pcfCmd.addParameter(MQConstants.MQIA_CLWL_Q_PRIORITY, wmqLocalQueue.getClwlQueuePriority());

		// Default Priority of local queue.This value should be through 0 to 9.
		pcfCmd.addParameter(MQConstants.MQIA_DEF_PRIORITY, wmqLocalQueue.getDefaultPriority());

		// PutMessage value for local queue may be either Allowed or Inhibited.

		if (WmqPutMessage.ALLOWED == wmqLocalQueue.getPutMessages()) {

			pcfCmd.addParameter(MQConstants.MQIA_INHIBIT_PUT, MQConstants.MQQA_PUT_ALLOWED);
		} else if (WmqPutMessage.INHIBITED == wmqLocalQueue.getPutMessages()) {

			pcfCmd.addParameter(MQConstants.MQIA_INHIBIT_PUT, MQConstants.MQQA_PUT_INHIBITED);
		}

		if (wmqQmanager.getVersion() != WmqVersion.WMQ_60) {

			// DefaultPutResponseType value may be either Synchronous or Asynchronous.

			if (WmqDefaultPutResponseType.SYNCHRONOUS == wmqLocalQueue.getDefaultPutResponseType()) {

				pcfCmd.addParameter(MQConstants.MQIA_DEF_PUT_RESPONSE_TYPE, MQConstants.MQPRT_SYNC_RESPONSE);
			} else if (WmqDefaultPutResponseType.ASYNCHRONOUS == wmqLocalQueue.getDefaultPutResponseType()) {

				pcfCmd.addParameter(MQConstants.MQIA_DEF_PUT_RESPONSE_TYPE, MQConstants.MQPRT_ASYNC_RESPONSE);
			}

			// Property Control value may be either Compatability,None,All,ForceMQRFH2.
			if (WmqPropertyControl.COMPATABILITY == wmqLocalQueue.getPropertyControl()) {
				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_COMPATIBILITY);
			} else if (WmqPropertyControl.NONE == wmqLocalQueue.getPropertyControl()) {
				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_NONE);
			} else if (WmqPropertyControl.ALL == wmqLocalQueue.getPropertyControl()) {
				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_ALL);
			} else if (WmqPropertyControl.FORCE_MQ_RFH2 == wmqLocalQueue.getPropertyControl()) {
				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_FORCE_MQRFH2);
			}

			// DefaultReadAhead value may be either Yes or No or Disabled.
			if (WmqDefaultReadAhead.YES == wmqLocalQueue.getDefaultReadAhead()) {
				pcfCmd.addParameter(MQConstants.MQIA_DEF_READ_AHEAD, MQConstants.MQREADA_YES);
			} else if (WmqDefaultReadAhead.NO == wmqLocalQueue.getDefaultReadAhead()) {
				pcfCmd.addParameter(MQConstants.MQIA_DEF_READ_AHEAD, MQConstants.MQREADA_NO);
			} else if (WmqDefaultReadAhead.DISABLED == wmqLocalQueue.getDefaultReadAhead()) {
				pcfCmd.addParameter(MQConstants.MQIA_DEF_READ_AHEAD, MQConstants.MQREADA_DISABLED);
			}
		}

		// GetMessages value may be either Allowed or Inhibited.
		if (WmqGetMessages.ALLOWED == wmqLocalQueue.getGetMessages()) {
			pcfCmd.addParameter(MQConstants.MQIA_INHIBIT_GET, MQConstants.MQQA_GET_ALLOWED);
		} else if (WmqGetMessages.INHIBITED == wmqLocalQueue.getGetMessages()) {
			pcfCmd.addParameter(MQConstants.MQIA_INHIBIT_GET, MQConstants.MQQA_GET_INHIBITED);
		}

		// Description of the Queue.
		if (StringUtils.isNotBlank(wmqLocalQueue.getDescription())) {
			pcfCmd.addParameter(MQConstants.MQCA_Q_DESC, wmqLocalQueue.getDescription());
		}

		// MaxQueueDepth of the localqueue varies through 0 to 999 999 999.
		pcfCmd.addParameter(MQConstants.MQIA_MAX_Q_DEPTH, wmqLocalQueue.getMaxQueueDepth());

		// MaxMsgLength of the localqueue varies through 0 to 999 999 999.
		pcfCmd.addParameter(MQConstants.MQIA_MAX_MSG_LENGTH, wmqLocalQueue.getMaxMessageLength());

		// DefaultInputOpenOption value may be either InputExclusive,InputShared.
		if (WmqDefaultInputOpenOption.INPUT_EXCLUSIVE == wmqLocalQueue.getDefaultInputOpenOption()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_INPUT_OPEN_OPTION, MQConstants.MQOO_INPUT_EXCLUSIVE);
		} else if (WmqDefaultInputOpenOption.INPUT_SHARED == wmqLocalQueue.getDefaultInputOpenOption()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_INPUT_OPEN_OPTION, MQConstants.MQOO_INPUT_SHARED);
		}

		// Shareability value may be either Shareable, NotShareable.
		if (WmqShareability.SHAREABLE == wmqLocalQueue.getShareability()) {
			pcfCmd.addParameter(MQConstants.MQIA_SHAREABILITY, MQConstants.MQQA_SHAREABLE);
		} else if (WmqShareability.NOT_SHAREABLE == wmqLocalQueue.getShareability()) {
			pcfCmd.addParameter(MQConstants.MQIA_SHAREABILITY, MQConstants.MQQA_NOT_SHAREABLE);
		}

		// Retention Interval value may be through 0 to 999 999 999.
		pcfCmd.addParameter(MQConstants.MQIA_RETENTION_INTERVAL, wmqLocalQueue.getRetentionInterval());

		// DistributionLists value may be either Supported or NotSupported.
		if (WmqDistributionLists.SUPPORTED == wmqLocalQueue.getDistributionLists()) {
			pcfCmd.addParameter(MQConstants.MQIA_DIST_LISTS, MQConstants.MQDL_SUPPORTED);
		} else if (WmqDistributionLists.NOT_SUPPORTED == wmqLocalQueue.getDistributionLists()) {
			pcfCmd.addParameter(MQConstants.MQIA_DIST_LISTS, MQConstants.MQDL_NOT_SUPPORTED);
		}

		// CLWLUseQueue value may be either Queuemanager or Any or Local.
		if (WmqCLWLUseQueue.QUEUE_MANAGER == wmqLocalQueue.getClwlUseQueue()) {
			pcfCmd.addParameter(MQConstants.MQIA_CLWL_USEQ, MQConstants.MQCLWL_USEQ_AS_Q_MGR);
		} else if (WmqCLWLUseQueue.ANY == wmqLocalQueue.getClwlUseQueue()) {
			pcfCmd.addParameter(MQConstants.MQIA_CLWL_USEQ, MQConstants.MQCLWL_USEQ_ANY);
		} else if (WmqCLWLUseQueue.LOCAL == wmqLocalQueue.getClwlUseQueue()) {
			pcfCmd.addParameter(MQConstants.MQIA_CLWL_USEQ, MQConstants.MQCLWL_USEQ_LOCAL);
		}

		// TriggerControl value may be either Off or On.
		if (WmqTriggerControl.OFF == wmqLocalQueue.getTriggerControl()) {
			pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_CONTROL, MQConstants.MQTC_OFF);
		} else if (WmqTriggerControl.ON == wmqLocalQueue.getTriggerControl()) {
			pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_CONTROL, MQConstants.MQTC_ON);
		}

		// TriggerType value may be either Depth or Every or First or None.
		if (WmqTriggerType.DEPTH == wmqLocalQueue.getTriggerType()) {
			pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_TYPE, MQConstants.MQTT_DEPTH);
		} else if (WmqTriggerType.EVERY == wmqLocalQueue.getTriggerType()) {
			pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_TYPE, MQConstants.MQTT_EVERY);
		} else if (WmqTriggerType.FIRST == wmqLocalQueue.getTriggerType()) {
			pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_TYPE, MQConstants.MQTT_FIRST);
		} else if (WmqTriggerType.NONE == wmqLocalQueue.getTriggerType()) {
			pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_TYPE, MQConstants.MQTT_NONE);
		}

		// TriggerDepth value should be in the range 1 through 999 999 999.
		if (wmqLocalQueue.getTriggerDepth() != 0) {
			pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_DEPTH, wmqLocalQueue.getTriggerDepth());
		}

		// TriggerMessagePriority value should be in the range through 0 to 9.
		pcfCmd.addParameter(MQConstants.MQIA_TRIGGER_MSG_PRIORITY, wmqLocalQueue.getTriggerMessagePriority());

		// TriggerData specifies user data that the queue manager includes in the trigger message.
		if (wmqLocalQueue.getTriggerData() != null && !"".equals(wmqLocalQueue.getTriggerData())) {
			pcfCmd.addParameter(MQConstants.MQCA_TRIGGER_DATA, wmqLocalQueue.getTriggerData());
		}
		// InitiationQueue is the local queue for trigger messages relating to this queue. The initiation queue must be on the same queue manager.
		if (wmqLocalQueue.getInitiationQueue() != null && !"".equals(wmqLocalQueue.getInitiationQueue())) {
			pcfCmd.addParameter(MQConstants.MQCA_INITIATION_Q_NAME, wmqLocalQueue.getInitiationQueue());
		}
		// ProcessName specifies the local name of the WebSphere MQ process.
		if (wmqLocalQueue.getProcessName() != null && !"".equals(wmqLocalQueue.getProcessName())) {
			pcfCmd.addParameter(MQConstants.MQCA_PROCESS_NAME, wmqLocalQueue.getProcessName());
		}
		// QueueDepthMaxEvents value may be either Enabled,Disabled.
		if (WmqQueueDepthMaxEvents.ENABLED == wmqLocalQueue.getQueueDepthMaxEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_MAX_EVENT, MQConstants.MQEVR_ENABLED);
		} else if (WmqQueueDepthMaxEvents.DISABLED == wmqLocalQueue.getQueueDepthMaxEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_MAX_EVENT, MQConstants.MQEVR_DISABLED);
		}
		// QueueDepthHighEvents value may be either Disabled or Enabled.
		if (WmqQueueDepthHighEvents.ENABLED == wmqLocalQueue.getQueueDepthHighEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_HIGH_EVENT, MQConstants.MQEVR_ENABLED);
		} else if (WmqQueueDepthHighEvents.DISABLED == wmqLocalQueue.getQueueDepthHighEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_HIGH_EVENT, MQConstants.MQEVR_DISABLED);
		}
		// QueueDepthHighLimit value must be greater than or equal to zero and less than or equal to 100.The default value is 80.
		pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_HIGH_LIMIT, wmqLocalQueue.getQueueDepthHighLimit());

		// QueueDepthLowLimit value range from 0 to 100.The default value is 20.
		pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_LOW_LIMIT, wmqLocalQueue.getQueueDepthLowLimit());

		// QueueDepthLowEvents value may be either Enabled,Disabled.
		if (WmqQueueDepthLowEvents.ENABLED == wmqLocalQueue.getQueueDepthLowEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_LOW_EVENT, MQConstants.MQEVR_ENABLED);
		} else if (WmqQueueDepthLowEvents.DISABLED == wmqLocalQueue.getQueueDepthLowEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_DEPTH_LOW_EVENT, MQConstants.MQEVR_DISABLED);
		}

		// QueueServiceIntervalEvents value may be either High or None or Ok.
		if (WmqQueueServiceIntervalEvents.HIGH == wmqLocalQueue.getQueueServiceIntervalEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_SERVICE_INTERVAL_EVENT, MQConstants.MQQSIE_HIGH);
		} else if (WmqQueueServiceIntervalEvents.OK == wmqLocalQueue.getQueueServiceIntervalEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_SERVICE_INTERVAL_EVENT, MQConstants.MQQSIE_OK);
		} else if (WmqQueueServiceIntervalEvents.NONE == wmqLocalQueue.getQueueServiceIntervalEvents()) {
			pcfCmd.addParameter(MQConstants.MQIA_Q_SERVICE_INTERVAL_EVENT, MQConstants.MQQSIE_NONE);
		}

		// QueueServiceInterval value is in the range through 0 to 999 999 999 milliseconds.
		pcfCmd.addParameter(MQConstants.MQIA_Q_SERVICE_INTERVAL, wmqLocalQueue.getQueueServiceInterval());

		// BackoutRequeueQueue specifies the local name of the queue to which a message is transferred.
		if (wmqLocalQueue.getBackoutRequeueQueue() != null && !"".equals(wmqLocalQueue.getBackoutRequeueQueue())) {
			pcfCmd.addParameter(MQConstants.MQCA_BACKOUT_REQ_Q_NAME, wmqLocalQueue.getBackoutRequeueQueue());
		}

		// BackoutThreshold value is in the range 0 through 999 999 999.
		pcfCmd.addParameter(MQConstants.MQIA_BACKOUT_THRESHOLD, wmqLocalQueue.getBackoutThreshold());

		// HardengetBackout value Specifies whether the count of backed out messages is saved across restarts of the message queuemanager.
		if (WmqHardengetBackout.HARDENED == wmqLocalQueue.getHardengetBackout()) {
			pcfCmd.addParameter(MQConstants.MQIA_HARDEN_GET_BACKOUT, MQConstants.MQQA_BACKOUT_HARDENED);
		} else if (WmqHardengetBackout.NOT_HARDENED == wmqLocalQueue.getHardengetBackout()) {
			pcfCmd.addParameter(MQConstants.MQIA_HARDEN_GET_BACKOUT, MQConstants.MQQA_BACKOUT_NOT_HARDENED);
		}

		// NPMClass value may be either Normal or High.
		if (WmqNPMClass.NORMAL == wmqLocalQueue.getNpmClass()) {
			pcfCmd.addParameter(MQConstants.MQIA_NPM_CLASS, MQConstants.MQNPM_CLASS_NORMAL);
		} else if (WmqNPMClass.HIGH == wmqLocalQueue.getNpmClass()) {
			pcfCmd.addParameter(MQConstants.MQIA_NPM_CLASS, MQConstants.MQNPM_CLASS_HIGH);
		}

		// QueueMonitoring specifies whether online monitoring data is to be collected and, if so, the rate at which the data is collected.
		if (WmqQueueMonitoring.HIGH == wmqLocalQueue.getQueueMonitoring()) {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_Q, MQConstants.MQMON_HIGH);
		} else if (WmqQueueMonitoring.LOW == wmqLocalQueue.getQueueMonitoring()) {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_Q, MQConstants.MQMON_LOW);
		} else if (WmqQueueMonitoring.MEDIUM == wmqLocalQueue.getQueueMonitoring()) {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_Q, MQConstants.MQMON_MEDIUM);
		} else if (WmqQueueMonitoring.QUEUE_MANAGER == wmqLocalQueue.getQueueMonitoring()) {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_Q, MQConstants.MQMON_Q_MGR);
		} else if (WmqQueueMonitoring.OFF == wmqLocalQueue.getQueueMonitoring()) {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_Q, MQConstants.MQMON_OFF);
		}

		// QueueStatistics specifies statistics data collection is enabled or not.
		if (WmqQueueStatistics.ON == wmqLocalQueue.getQueueStatistics()) {
			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_Q, MQConstants.MQMON_ON);
		} else if (WmqQueueStatistics.OFF == wmqLocalQueue.getQueueStatistics()) {
			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_Q, MQConstants.MQMON_OFF);
		} else if (WmqQueueStatistics.QUEUE_MANAGER == wmqLocalQueue.getQueueStatistics()) {
			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_Q, MQConstants.MQMON_Q_MGR);
		}

		// QueueAccounting controls the collection of accounting data.
		if (WmqQueueAccounting.ON == wmqLocalQueue.getQueueAccounting()) {
			pcfCmd.addParameter(MQConstants.MQIA_ACCOUNTING_Q, MQConstants.MQMON_ON);
		} else if (WmqQueueAccounting.OFF == wmqLocalQueue.getQueueAccounting()) {
			pcfCmd.addParameter(MQConstants.MQIA_ACCOUNTING_Q, MQConstants.MQMON_OFF);
		} else if (WmqQueueAccounting.QUEUE_MANAGER == wmqLocalQueue.getQueueAccounting()) {
			pcfCmd.addParameter(MQConstants.MQIA_ACCOUNTING_Q, MQConstants.MQMON_Q_MGR);
		}

		// MessageDeliverySequence value may be either Priority or Fifo.
		if (WmqMessageDeliverySequence.PRIORITY == wmqLocalQueue.getMessageDeliverySequence()) {
			pcfCmd.addParameter(MQConstants.MQIA_MSG_DELIVERY_SEQUENCE, MQConstants.MQMDS_PRIORITY);
		} else if (WmqMessageDeliverySequence.FIFO == wmqLocalQueue.getMessageDeliverySequence()) {
			pcfCmd.addParameter(MQConstants.MQIA_MSG_DELIVERY_SEQUENCE, MQConstants.MQMDS_FIFO);
		}

		// Usage value tells whether the queue is an normal or transmission queue.
		if (WmqUsage.NORMAL == wmqLocalQueue.getUsage()) {
			pcfCmd.addParameter(MQConstants.MQIA_USAGE, MQConstants.MQUS_NORMAL);
		} else if (WmqUsage.TRANSMISSION == wmqLocalQueue.getUsage()) {
			pcfCmd.addParameter(MQConstants.MQIA_USAGE, MQConstants.MQUS_TRANSMISSION);
		}

		// DefinitionBindType
		if (WmqDefaultBindType.ON_OPEN == wmqLocalQueue.getDefaultBindType()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_BIND, MQConstants.MQBND_BIND_ON_OPEN);
		} else if (WmqDefaultBindType.NOT_FIXED == wmqLocalQueue.getDefaultBindType()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_BIND, MQConstants.MQBND_BIND_NOT_FIXED);
		}
		if (wmqLocalQueue.getClusterName() != null && wmqLocalQueue.getClusterNamelist() != null) {
			throw new MQPluginException("Clustername and Cluster Namelist both should not be given at a time in CI");
		}

		// ClusterName is the name of the cluster to which the queue belongs.
		if (StringUtils.isNotBlank(wmqLocalQueue.getClusterName())) {
			pcfCmd.addParameter(MQConstants.MQCA_CLUSTER_NAME, wmqLocalQueue.getClusterName());
		}
		// ClusterNamelistName is the name of the namelist, that specifies a list of clusters to which the queue belongs.
		if (StringUtils.isNotBlank(wmqLocalQueue.getClusterNamelist())) {
			pcfCmd.addParameter(MQConstants.MQCA_CLUSTER_NAMELIST, wmqLocalQueue.getClusterNamelist());
		}

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating LocalQueue \"" + wmqLocalQueue.getQueueName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
		}
		return "Creating LocalQueue Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The LocalQueue \"" + wmqLocalQueue.getQueueName() + "\" is created on QueueManager\"" + this.wmqQmanager.getQueueManagerName() + "\"";

	}

}
