/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.ModificationSupportingMappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wmq.ci.WmqNetBIOSListener;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqResourceMapping;
import com.xebialabs.deployit.plugin.wmq.step.CreateWmqNetBIOSListenerStep;
import com.xebialabs.deployit.plugin.wmq.step.DestroyWmqListenerStep;
import com.xebialabs.deployit.plugin.wmq.step.ModifyWmqNetBIOSListenerStep;
import com.xebialabs.deployit.plugin.wmq.step.StartWmqListenerStep;
import com.xebialabs.deployit.plugin.wmq.step.StopWmqListenerStep;

public class WmqNetBIOSListenerToWmqQueueManagerMapper extends
        ModificationSupportingMappingAgnosticStepGeneratingMapper<WmqNetBIOSListener, WmqResourceMapping, WmqQueueManager> {

	public WmqNetBIOSListenerToWmqQueueManagerMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WmqNetBIOSListener wmqNetBIOSListener, WmqQueueManager wmqQmanager, List<Step> steps) {
		steps.add(new CreateWmqNetBIOSListenerStep(wmqNetBIOSListener, wmqQmanager));
		steps.add(new StartWmqListenerStep(wmqNetBIOSListener, wmqQmanager));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WmqNetBIOSListener wmqNetBIOSListener, WmqQueueManager wmqQmanager, List<Step> steps) {

		steps.add(new StopWmqListenerStep(wmqNetBIOSListener, wmqQmanager));
		steps.add(new DestroyWmqListenerStep(wmqNetBIOSListener, wmqQmanager));

	}

	@Override
	protected void generateModificationStepsForModifiedMapping(WmqNetBIOSListener oldNetBiosListener, WmqQueueManager oldQueueManager,
	        WmqNetBIOSListener newNetBiosListener, WmqQueueManager newQueueManager, List<Step> steps) {
		steps.add(new ModifyWmqNetBIOSListenerStep(newNetBiosListener, newQueueManager));

	}

}