/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.utils.RegexUtils;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class CheckWmqChannelStep
implements Step {
    private WmqQueueManager wmqQueueManager;

    public CheckWmqChannelStep(WmqQueueManager wmqQueueManager) {
        this.wmqQueueManager = wmqQueueManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession hostSession = this.wmqQueueManager.getHostName().getHostSession();
        ArrayList<String> list = new ArrayList<String>();
        try {
            CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
            ArrayList<String> cmd = new ArrayList<String>();
            if (this.wmqQueueManager.getHostName().getOperatingSystemFamily() == OperatingSystemFamily.WINDOWS) {
                cmd.add("cmd");
                cmd.add("/c");
            }
            cmd.add("echo");
            cmd.add("dis");
            cmd.add("chl(*)");
            cmd.add("trptype");
            cmd.add("type(svrconn)");
            cmd.add("|");
            cmd.add("runmqsc");
            cmd.add(this.wmqQueueManager.getQueueManagerName());
            Object[] cmdArray = cmd.toArray(new String[cmd.size()]);
            int res = hostSession.execute((CommandExecutionCallbackHandler)capturedOutput, (String[])cmdArray);
            if (res != 0 && res != 10) {
                ctx.logError("Non-zero exitcode from " + StringUtils.join((Object[])cmdArray, (String)" ") + ": " + res);
                boolean bl = false;
                return bl;
            }
            for (String eachLine : capturedOutput.getOutputLines()) {
                String[] matches;
                if (!eachLine.contains("CHANNEL") || (matches = RegexUtils.regexMatch(eachLine, "\\s+CHANNEL\\((\\S+)\\)[\\s\\S]*")) == null || matches.length != 1) continue;
                list.add(matches[0]);
            }
        }
        finally {
            hostSession.close();
        }
        if (list.size() > 0) {
            ctx.logOutput("Available Queue Manager Server Connection Channel Names " + list);
            this.wmqQueueManager.setChannelName((String)list.get(0));
            ctx.logOutput("The channel \"" + (String)list.get(0) + "\" is set to the QueueManager \"" + this.wmqQueueManager.getQueueManagerName() + "\"");
            if (list.size() > 1) {
                ctx.logOutput("User can change the channel on the QueueManager after the discovery process is completed to any of the above mentioned channel names");
            }
            return true;
        }
        ctx.logError("Could not determine Channel Name of Queue Manager " + this.wmqQueueManager.getQueueManagerName());
        return false;
    }

    public String getDescription() {
        if (this.wmqQueueManager.getQueueManagerName() != null) {
            return "Check Wmq Channel Step for \"" + this.wmqQueueManager.getQueueManagerName() + "\"";
        }
        return "Check Wmq Channel Step";
    }
}

