/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.plugin.wmq.enums.WmqApplicationType;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "The MQProcess class of objects represents an individual process definition defined on a particular queue manager. Enumerating an object of this class results in an empty list.")
public class WmqProcessDefinition extends BaseConfigurationItem implements WmqResource {

	@ConfigurationItemProperty(required = true, label = "Process name", identifying = true, description = "The name of the process definition to be changed or created.The maximum length of the string is MQ_PROCESS_NAME_LENGTH.", size = Size.LARGE)
	private String processName;

	@ConfigurationItemProperty(label = "Process Description", description = " A plain-text comment that provides descriptive information about the process definition.string is MQ_PROCESS_DESC_LENGTH.", size = Size.LARGE)
	private String description;

	@ConfigurationItemProperty(label = "Application Type", description = "ApplicationType and ApplicationTypeInt both should not be given at a time in CI", size = Size.LARGE)
	private WmqApplicationType applicationType;

	@ConfigurationItemProperty(label = "Application Type", description = "ApplicationType and ApplicationTypeInt both should not be given at a time in CI.We can specify an integer in the range 65536 through 999999999", size = Size.LARGE)
	private int applicationTypeInt = Integer.MAX_VALUE;

	@ConfigurationItemProperty(label = "Environment Data", description = "A character string that contains environment information pertaining to the application to be started.The maximum length of the string is MQ_PROCESS_ENV_DATA_LENGTH.", size = Size.LARGE)
	private String environmentData;

	@ConfigurationItemProperty(label = "User Data", description = "A character string that contains user information pertaining to the application (defined by ApplId) that is to be started.The maximum length of the string is MQ_PROCESS_USER_DATA_LENGTH.", size = Size.LARGE)
	private String userData;

	@ConfigurationItemProperty(label = "ApplicationId", description = "This is the name of the application to be started, on the platform for which the command is executing, and might typically be a program name and library name.", size = Size.LARGE)
	private String applicationId;

	public int getApplicationTypeInt() {
		return applicationTypeInt;
	}

	public void setApplicationTypeInt(int applicationTypeInt) {
		this.applicationTypeInt = applicationTypeInt;
	}

	public String getProcessName() {
		return processName;
	}

	public String getApplicationId() {
		return applicationId;
	}

	public void setApplicationId(String applicationId) {
		this.applicationId = applicationId;
	}

	public void setProcessName(String processName) {
		this.processName = processName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public WmqApplicationType getApplicationType() {
		return applicationType;
	}

	public void setApplicationType(WmqApplicationType applicationType) {
		this.applicationType = applicationType;
	}

	public String getEnvironmentData() {
		return environmentData;
	}

	public void setEnvironmentData(String environmentData) {
		this.environmentData = environmentData;
	}

	public String getUserData() {
		return userData;
	}

	public void setUserData(String userData) {
		this.userData = userData;
	}

}