package com.xebialabs.deployit.plugin.wmq.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.plugin.wmq.ci.WmqLocalQueue;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;

@SuppressWarnings("serial")
public class DestroyWmqLocalQueueStep implements Step {

	private WmqQueueManager queueManager;
	private WmqLocalQueue queue;

	public DestroyWmqLocalQueueStep(WmqQueueManager queueManager, WmqLocalQueue queue) {
		this.queueManager = queueManager;
		this.queue = queue;
	}

	public boolean execute(StepExecutionContext ctx) {
		CommandExecutionCallbackHandler handler = new StepExecutionContextCallbackHandler(ctx);
		StringBuffer defineCommand = new StringBuffer();
		defineCommand.append("DELETE QLOCAL(");
		defineCommand.append(queue.getName());
		defineCommand.append(")");
		int exitValue = queueManager.executeRunMqscCommand(defineCommand.toString(), handler);
		return exitValue == 0;
	}

	public String getDescription() {
		return "Destroy queue " + queue + " on queue manager " + queueManager;
	}

}
