package com.xebialabs.deployit.plugin.wmq.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.ModificationSupportingMappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wmq.ci.WmqLocalQueue;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.step.CreateWmqLocalQueueStep;
import com.xebialabs.deployit.plugin.wmq.step.DestroyWmqLocalQueueStep;
import com.xebialabs.deployit.plugin.wmq.step.ModifyWmqLocalQueueStep;

public class WmqLocalQueueToWmqQueueManagerMapper extends ModificationSupportingMappingAgnosticStepGeneratingMapper<WmqLocalQueue, WmqQueueManager> {

	public WmqLocalQueueToWmqQueueManagerMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WmqLocalQueue newLocalQueue, WmqQueueManager qManager, List<Step> steps) {
		steps.add(new CreateWmqLocalQueueStep(qManager, newLocalQueue));
	}

	@Override
	protected void generateModificationStepsForModifiedMapping(WmqLocalQueue oldLocalQueue, WmqQueueManager oldQueueManager, WmqLocalQueue newLocalQueue,
			WmqQueueManager newQueueManager, List<Step> steps) {
		steps.add(new ModifyWmqLocalQueueStep(newQueueManager, newLocalQueue));

	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WmqLocalQueue oldLocalQueue, WmqQueueManager qManager, List<Step> steps) {
		steps.add(new DestroyWmqLocalQueueStep(qManager, oldLocalQueue));
	}

}
