package com.xebialabs.deployit.plugin.wmq.ci;

import java.io.PrintWriter;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.CommandExecution;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.common.ErrorStreamToCallbackHandler;
import com.xebialabs.deployit.hostsession.common.OutputStreamToCallbackHandler;

@SuppressWarnings("serial")
@ConfigurationItem
public class WmqQueueManager extends BaseConfigurationItem {

	public WmqQueueManager() {
		// no-op
	}

	public WmqQueueManager(String label, Host host, String name) {
		this.label = label;
		this.host = host;
		this.name = name;
	}

	@ConfigurationItemProperty(identifying = true)
	private Host host;

	@ConfigurationItemProperty(required = true, identifying = true)
	private String name;

	public Host getHost() {
		return host;
	}

	public void setHost(Host host) {
		this.host = host;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int executeRunMqscCommand(String line, CommandExecutionCallbackHandler handler) {
		HostSession s = getHost().getHostSession();
		try {
			CommandExecution runMqscCommand = s.startExecute("runmqsc", getName());

			Thread outputStreamForwardingThread = new Thread(new OutputStreamToCallbackHandler(runMqscCommand.getStdout(), handler));
			outputStreamForwardingThread.start();

			Thread errorStreamForwardingThread = new Thread(new ErrorStreamToCallbackHandler(runMqscCommand.getStderr(), handler));
			errorStreamForwardingThread.start();

			PrintWriter stdin = new PrintWriter(runMqscCommand.getStdin());
			try {
				stdin.println(line);
				stdin.println("END");
			} finally {
				stdin.close();
			}
			return runMqscCommand.waitFor();
		} finally {
			s.close();
		}
	}

}
