package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;

import java.util.Map;

/**
 *
 */
public class Wls8UndeployArtifactStep extends Wls8WeblogicDeployerStepBase implements Step {
	private String targetName;
	private String applicationName;
	private String extension;
	private String applicationLocation;

	public Wls8UndeployArtifactStep(WlsTarget target, NamedDeployableArtifact artifact) {
		super(target.getDomain());
		this.targetName = target.getName();
		this.applicationName = artifact.getName();
		this.extension = findOutExtension(artifact);
		this.applicationLocation = artifact.getLocation();
		setDescription("Undeploy " + artifact + " on " + target);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = domain.connectToAdminHost();
		try {

			Map<String, String> velocityContext = Maps.newHashMap();
			velocityContext.put("username", domain.getUsername());
			velocityContext.put("password", domain.getPassword());
			velocityContext.put("adminurl", domain.getConnectUrl());
			velocityContext.put("wlHome", domain.getWlHome());
			velocityContext.put("target", targetName);
			velocityContext.put("name", applicationName);
			velocityContext.put("deployerAction", " -undeploy ");

			return executeWeblogicDeployerScript(ctx, rhs, velocityContext) == 0;
		} finally {
			rhs.close();
		}
	}
}
