/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.Wls8WeblogicDeployerStepBase;
import java.util.HashMap;

public class Wls8UndeployArtifactStep
extends Wls8WeblogicDeployerStepBase
implements Step {
    private String targetName;
    private String applicationName;
    private String extension;
    private String applicationLocation;

    public Wls8UndeployArtifactStep(WlsTarget target, NamedDeployableArtifact artifact) {
        super(target.getDomain());
        this.targetName = target.getName();
        this.applicationName = artifact.getName();
        this.extension = this.findOutExtension(artifact);
        this.applicationLocation = artifact.getLocation();
        this.setDescription("Undeploy " + artifact + " on " + (Object)((Object)target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.domain.connectToAdminHost();
        try {
            HashMap velocityContext = Maps.newHashMap();
            velocityContext.put("username", this.domain.getUsername());
            velocityContext.put("password", this.domain.getPassword());
            velocityContext.put("adminurl", this.domain.getConnectUrl());
            velocityContext.put("wlHome", this.domain.getWlHome());
            velocityContext.put("target", this.targetName);
            velocityContext.put("name", this.applicationName);
            velocityContext.put("deployerAction", " -undeploy ");
            boolean bl = this.executeWeblogicDeployerScript(ctx, rhs, velocityContext) == 0;
            return bl;
        }
        finally {
            rhs.close();
        }
    }
}

