/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDataSource;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.step.SimpleWlstExecutingStep;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class CreateWlsDataSourceStep
extends SimpleWlstExecutingStep {
    public static final String SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/wls/step/create-datasource.py";

    public CreateWlsDataSourceStep(WlsCluster cluster, WlsDataSource wlsDataSource) {
        super("Create datasource " + wlsDataSource + " on cluster " + (Object)((Object)cluster), cluster.getDomain(), SCRIPT_RESOURCE_PATH, CreateWlsDataSourceStep.getArgs(cluster.getTargetObjectName(), wlsDataSource));
    }

    public CreateWlsDataSourceStep(WlsServer cluster, WlsDataSource wlsDataSource) {
        super("Create datasource " + wlsDataSource + " on server " + (Object)((Object)cluster), cluster.getDomain(), SCRIPT_RESOURCE_PATH, CreateWlsDataSourceStep.getArgs(cluster.getTargetObjectName(), wlsDataSource));
    }

    private static String[] getArgs(String targetObjectName, WlsDataSource webLogicDatasource) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(targetObjectName);
        args.add(webLogicDatasource.getName());
        args.add(webLogicDatasource.getJndiName());
        args.add(webLogicDatasource.getUri());
        if (StringUtils.isBlank((String)webLogicDatasource.getUserName())) {
            args.add("");
        } else {
            args.add(webLogicDatasource.getUserName());
        }
        if (StringUtils.isBlank((String)webLogicDatasource.getPassword())) {
            args.add("");
        } else {
            args.add(webLogicDatasource.getPassword());
        }
        args.add(webLogicDatasource.getDriver());
        args.add(String.valueOf(webLogicDatasource.getInit()));
        args.add(String.valueOf(webLogicDatasource.getMax()));
        if (webLogicDatasource.getProperties() != null) {
            args.add(webLogicDatasource.getProperties());
        } else {
            args.add("");
        }
        return args.toArray(new String[args.size()]);
    }
}

