#
# Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys

scriptname = sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)
servername = sys.argv.pop(0)
wlhome = sys.argv.pop(0)

arguments = ""
classpathargument = ""
logfilepath = ""
redirectstdouttoserverlog = ''
listenport = ""

print "Connecting to WebLogic"
connect(user, password, url)
edit()
startEdit()

print "Modifying server " + servername
while len(sys.argv) >= 2:
	propname = sys.argv.pop(0)
	propvalue = sys.argv.pop(0);
    
	if propname == 'arguments':
		arguments = arguments + ' ' + propvalue
		
	elif propname == 'classpath':
		classpathargument = propvalue
		print "Setting server property " + propname + " to value " + classpathargument
		
	# logging related arguments
	elif propname == 'logfilename':
		logfilepath = propvalue
		print "Setting server property " + propname + " to value " + logfilepath

	elif propname == 'logfileseveritylevel':
		loggingseverity = propvalue
		print "Setting server property " + propname + " to value " + loggingseverity

	elif propname == 'redirectstdouttoserverlog':
		redirectstdouttoserverlog = propvalue
		print "Setting server property " + propname + " to value " + redirectstdouttoserverlog
		
	elif propname == 'listenport':
		listenport = propvalue
		print "Setting server property " + propname + " to value " + listenport
		
	else:
		print "Skipping unknown property " + propname + " with value " + propvalue

if arguments != "" or classpathargument != "":
		cd('/Servers/' +servername+ '/ServerStart/' + servername)
		if arguments != "":
			print "Configuring Server "+servername+" with arguments : "+arguments
			cmo.setArguments(arguments);
		
		if classpathargument != "":
			print "Configuring Server "+servername+" with classpath : "+classpathargument
			# WebLogic Server needs mimumum : WL_HOME/server/lib/weblogic.jar in it's CLASSPATH for starting up
			cmo.setClassPath(classpathargument);
			
if logfilepath != "" or redirectstdouttoserverlog != "":
	    cd('/Servers/' +servername+ '/Log/' + servername)
	    if logfilepath != "":
	    	cmo.setFileName(logfilepath)
	    
	    if redirectstdouttoserverlog != "":
	    	cmo.setRedirectStdoutToServerLogEnabled(redirectstdouttoserverlog=='true')

if listenport != "":
	cd('/Servers/' + servername)
	cmo.setListenPort(int(listenport))

print "Saving configuration"
save()	
disconnect('true')
exit('y')

