/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import java.net.HttpURLConnection;
import java.net.URL;

public class WlsDomainCheckReachableStep
implements Step {
    protected final WlsDomain domain;

    public WlsDomainCheckReachableStep(WlsDomain domain) {
        this.domain = domain;
    }

    public boolean execute(StepExecutionContext ctx) {
        try {
            ctx.logOutput(this.getDescription());
            URL wlsDomainHomePageUrl = new URL("http://" + this.domain.getActiveHost().getAddress() + ":" + this.domain.getPort());
            HttpURLConnection con = (HttpURLConnection)wlsDomainHomePageUrl.openConnection();
            con.getResponseMessage();
            return true;
        }
        catch (Exception exc) {
            ctx.logError("Cannot connect to WLS server", (Throwable)exc);
            return false;
        }
    }

    public String getDescription() {
        return "Checking reachability of Wls domain " + (Object)((Object)this.domain) + " on host " + this.domain.getActiveHost() + " on port " + this.domain.getPort() + " using URL http://" + this.domain.getActiveHost().getAddress() + ":" + this.domain.getPort();
    }
}

