/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.artifact.ConfigurationFilesToHostMapper;
import com.xebialabs.deployit.mapper.artifact.LibrariesToHostMapper;
import com.xebialabs.deployit.mapper.artifact.SqlScriptToDatabaseMapper;
import com.xebialabs.deployit.plugin.apache.httpd.mapper.StaticContentToApacheHttpdServerMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsServerResourceMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.mapper.ApacheHttpdWlsPluginConfigurationToApacheHttpdServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.EarToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.EarToWlsServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.EjbJarToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.EjbJarToWlsServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.JmsMapperUtils;
import com.xebialabs.deployit.plugin.wls.mapper.WarToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WarToWlsServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsDataSourceToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsDataSourceToWlsServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsForeignDestinationToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsForeignJmsConnectionFactoryToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsForeignServerToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsJmsConnectionFactoryToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsJmsQueueToWlsServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsJmsServerToWlsServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsMaximumThreadsConstraintToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsSharedLibraryJarToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsSharedLibraryJarToWlsServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsWorkManagerToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.runbook.WlsServerRunBook;
import com.xebialabs.deployit.plugin.wls.step.ActivatePendingChangesStep;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsJmsModuleStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsJmsModuleStep;
import com.xebialabs.deployit.plugin.wls.step.RestartServersThatRequireRestartStep;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WlsDeploymentRunBook
extends SingleTypeHandlingRunBook<Deployment>
implements RunBook {
    public WlsDeploymentRunBook() {
        super(Deployment.class);
    }

    protected void resolve(Change<Deployment> change, ChangePlan changePlan, List<Step> steps) {
        EarToWlsClusterMapper earToClusterMapper = new EarToWlsClusterMapper(change);
        EarToWlsServerMapper earToServerMapper = new EarToWlsServerMapper(change);
        EjbJarToWlsClusterMapper ejbToClusterMapper = new EjbJarToWlsClusterMapper(change);
        EjbJarToWlsServerMapper ejbToServerMapper = new EjbJarToWlsServerMapper(change);
        WarToWlsClusterMapper warToClusterMapper = new WarToWlsClusterMapper(change);
        WarToWlsServerMapper warToServerMapper = new WarToWlsServerMapper(change);
        WlsSharedLibraryJarToWlsServerMapper libJarToServerMapper = new WlsSharedLibraryJarToWlsServerMapper(change);
        WlsSharedLibraryJarToWlsClusterMapper libJarToClusterMapper = new WlsSharedLibraryJarToWlsClusterMapper(change);
        WlsDataSourceToWlsClusterMapper dataSourceToClusterMapper = new WlsDataSourceToWlsClusterMapper(change);
        WlsDataSourceToWlsServerMapper dataSourceToServerMapper = new WlsDataSourceToWlsServerMapper(change);
        WlsJmsServerToWlsServerMapper jmsServerToServerMapper = new WlsJmsServerToWlsServerMapper(change);
        WlsJmsQueueToWlsServerMapper jmsQueueToServerMapper = new WlsJmsQueueToWlsServerMapper(change);
        this.sortQueueMappings(jmsQueueToServerMapper);
        WlsJmsConnectionFactoryToWlsClusterMapper jmsConnectionFactoryToClusterMapper = new WlsJmsConnectionFactoryToWlsClusterMapper(change);
        WlsForeignServerToWlsClusterMapper jmsForeignServerToClusterMapper = new WlsForeignServerToWlsClusterMapper(change);
        WlsForeignDestinationToWlsClusterMapper jmsForeignDestinationToClusterMapper = new WlsForeignDestinationToWlsClusterMapper(change);
        WlsForeignJmsConnectionFactoryToWlsClusterMapper jmsForeignJmsConnectionFactoryToClusterMapper = new WlsForeignJmsConnectionFactoryToWlsClusterMapper(change);
        WlsMaximumThreadsConstraintToWlsClusterMapper maxThreadsConstraintsToClusterMapper = new WlsMaximumThreadsConstraintToWlsClusterMapper(change);
        WlsWorkManagerToWlsClusterMapper workManagerToClusterMapper = new WlsWorkManagerToWlsClusterMapper(change);
        ApacheHttpdWlsPluginConfigurationToApacheHttpdServerMapper pluginConfigMapper = new ApacheHttpdWlsPluginConfigurationToApacheHttpdServerMapper(change);
        StaticContentToApacheHttpdServerMapper staticContentMapper = new StaticContentToApacheHttpdServerMapper(change);
        LibrariesToHostMapper librariesMapper = new LibrariesToHostMapper(change);
        ConfigurationFilesToHostMapper configurationFilesToHostMapper = new ConfigurationFilesToHostMapper(change);
        HashSet<WlsCluster> allClusters = new HashSet<WlsCluster>();
        allClusters.addAll(dataSourceToClusterMapper.getAllTargets());
        allClusters.addAll(jmsConnectionFactoryToClusterMapper.getAllTargets());
        allClusters.addAll(jmsForeignServerToClusterMapper.getAllTargets());
        allClusters.addAll(jmsForeignDestinationToClusterMapper.getAllTargets());
        allClusters.addAll(jmsForeignJmsConnectionFactoryToClusterMapper.getAllTargets());
        allClusters.addAll(maxThreadsConstraintsToClusterMapper.getAllTargets());
        allClusters.addAll(workManagerToClusterMapper.getAllTargets());
        allClusters.addAll(earToClusterMapper.getAllTargets());
        allClusters.addAll(warToClusterMapper.getAllTargets());
        allClusters.addAll(ejbToClusterMapper.getAllTargets());
        allClusters.addAll(libJarToClusterMapper.getAllTargets());
        HashSet<WlsServer> allServers = new HashSet<WlsServer>();
        allServers.addAll(dataSourceToServerMapper.getAllTargets());
        allServers.addAll(jmsServerToServerMapper.getAllTargets());
        allServers.addAll(jmsQueueToServerMapper.getAllTargets());
        allServers.addAll(earToServerMapper.getAllTargets());
        allServers.addAll(warToServerMapper.getAllTargets());
        allServers.addAll(ejbToServerMapper.getAllTargets());
        allServers.addAll(libJarToServerMapper.getAllTargets());
        if (!this.isWlsDeployment(allClusters, allServers)) {
            return;
        }
        HashSet affectedClusters = new HashSet();
        affectedClusters.addAll(dataSourceToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(jmsConnectionFactoryToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(jmsForeignServerToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(jmsForeignDestinationToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(jmsForeignJmsConnectionFactoryToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(maxThreadsConstraintsToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(workManagerToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(earToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(warToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(ejbToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(libJarToClusterMapper.getAffectedTargets());
        HashSet affectedServers = new HashSet();
        affectedServers.addAll(dataSourceToServerMapper.getAffectedTargets());
        affectedServers.addAll(jmsServerToServerMapper.getAffectedTargets());
        affectedServers.addAll(jmsQueueToServerMapper.getAffectedTargets());
        affectedServers.addAll(earToServerMapper.getAffectedTargets());
        affectedServers.addAll(warToServerMapper.getAffectedTargets());
        affectedServers.addAll(ejbToServerMapper.getAffectedTargets());
        affectedServers.addAll(libJarToServerMapper.getAffectedTargets());
        HashSet<WlsDomain> affectedDomains = new HashSet<WlsDomain>();
        for (WlsCluster eachCluster : affectedClusters) {
            affectedDomains.add(eachCluster.getDomain());
        }
        for (WlsServer eachServer : affectedServers) {
            affectedDomains.add(eachServer.getDomain());
        }
        HashSet oldJmsTargetedServers = new HashSet();
        oldJmsTargetedServers.addAll(jmsServerToServerMapper.getOldTargets());
        oldJmsTargetedServers.addAll(jmsQueueToServerMapper.getOldTargets());
        HashSet newJmsTargetedServers = new HashSet();
        newJmsTargetedServers.addAll(jmsServerToServerMapper.getNewTargets());
        newJmsTargetedServers.addAll(jmsQueueToServerMapper.getNewTargets());
        HashSet oldJmsTargetedClusters = new HashSet();
        oldJmsTargetedClusters.addAll(jmsConnectionFactoryToClusterMapper.getOldTargets());
        oldJmsTargetedClusters.addAll(jmsForeignServerToClusterMapper.getOldTargets());
        oldJmsTargetedClusters.addAll(jmsForeignDestinationToClusterMapper.getOldTargets());
        oldJmsTargetedClusters.addAll(jmsForeignJmsConnectionFactoryToClusterMapper.getOldTargets());
        HashSet newJmsTargetedClusters = new HashSet();
        newJmsTargetedClusters.addAll(jmsConnectionFactoryToClusterMapper.getNewTargets());
        newJmsTargetedClusters.addAll(jmsForeignServerToClusterMapper.getNewTargets());
        newJmsTargetedClusters.addAll(jmsForeignDestinationToClusterMapper.getNewTargets());
        newJmsTargetedClusters.addAll(jmsForeignJmsConnectionFactoryToClusterMapper.getNewTargets());
        int lastStepCount = steps.size();
        earToClusterMapper.generateUndeploySteps(steps);
        earToServerMapper.generateUndeploySteps(steps);
        warToClusterMapper.generateUndeploySteps(steps);
        warToServerMapper.generateUndeploySteps(steps);
        ejbToClusterMapper.generateUndeploySteps(steps);
        ejbToServerMapper.generateUndeploySteps(steps);
        libJarToClusterMapper.generateUndeploySteps(steps);
        libJarToServerMapper.generateUndeploySteps(steps);
        if (steps.size() > lastStepCount) {
            this.activateChanges(steps, affectedDomains);
        }
        lastStepCount = steps.size();
        jmsQueueToServerMapper.generateDeletionSteps(steps);
        jmsConnectionFactoryToClusterMapper.generateDeletionSteps(steps);
        jmsServerToServerMapper.generateDeletionSteps(steps);
        jmsForeignDestinationToClusterMapper.generateDeletionSteps(steps);
        jmsForeignJmsConnectionFactoryToClusterMapper.generateDeletionSteps(steps);
        jmsForeignServerToClusterMapper.generateDeletionSteps(steps);
        for (WlsTarget each : oldJmsTargetedServers) {
            if (newJmsTargetedServers.contains((Object)each)) continue;
            steps.add(new DestroyWlsJmsModuleStep(((WlsServer)each).getDomain(), JmsMapperUtils.getJmsModuleName(change, each)));
        }
        for (WlsTarget each : oldJmsTargetedClusters) {
            if (newJmsTargetedClusters.contains((Object)each)) continue;
            steps.add(new DestroyWlsJmsModuleStep(((WlsCluster)each).getDomain(), JmsMapperUtils.getJmsModuleName(change, each)));
        }
        dataSourceToServerMapper.generateDeletionSteps(steps);
        dataSourceToClusterMapper.generateDeletionSteps(steps);
        workManagerToClusterMapper.generateDeletionSteps(steps);
        maxThreadsConstraintsToClusterMapper.generateDeletionSteps(steps);
        if (steps.size() > lastStepCount) {
            this.activateChanges(steps, affectedDomains);
        }
        configurationFilesToHostMapper.generateDeletionSteps(steps);
        configurationFilesToHostMapper.generateAdditionSteps(steps);
        librariesMapper.generateDeletionSteps(steps);
        librariesMapper.generateAdditionSteps(steps);
        if (change.isModification()) {
            HashSet<WlsServer> oldApplicationTargetServers = new HashSet<WlsServer>();
            oldApplicationTargetServers.addAll(earToServerMapper.getOldTargets());
            oldApplicationTargetServers.addAll(warToServerMapper.getOldTargets());
            oldApplicationTargetServers.addAll(ejbToServerMapper.getOldTargets());
            HashSet oldApplicationTargetClusters = new HashSet();
            oldApplicationTargetClusters.addAll(earToClusterMapper.getOldTargets());
            oldApplicationTargetClusters.addAll(warToClusterMapper.getOldTargets());
            oldApplicationTargetClusters.addAll(ejbToClusterMapper.getOldTargets());
            oldApplicationTargetClusters.addAll(libJarToClusterMapper.getOldTargets());
            for (WlsCluster cluster : oldApplicationTargetClusters) {
                oldApplicationTargetServers.addAll(cluster.getServers());
            }
            HashSet<WlsServer> newApplicationTargetServers = new HashSet<WlsServer>();
            newApplicationTargetServers.addAll(earToServerMapper.getNewTargets());
            newApplicationTargetServers.addAll(warToServerMapper.getNewTargets());
            newApplicationTargetServers.addAll(ejbToServerMapper.getNewTargets());
            HashSet newApplicationTargetClusters = new HashSet();
            newApplicationTargetClusters.addAll(earToClusterMapper.getNewTargets());
            newApplicationTargetClusters.addAll(warToClusterMapper.getNewTargets());
            newApplicationTargetClusters.addAll(ejbToClusterMapper.getNewTargets());
            newApplicationTargetClusters.addAll(libJarToClusterMapper.getNewTargets());
            for (WlsCluster cluster : newApplicationTargetClusters) {
                newApplicationTargetServers.addAll(cluster.getServers());
            }
            Set<Change<WlsServer>> serverChangesForDeploymentChange = this.findServerChangesForDeploymentChange(changePlan, change, oldApplicationTargetServers, newApplicationTargetServers);
            if (serverChangesForDeploymentChange != null) {
                WlsServerRunBook wlsServerRunBook = new WlsServerRunBook();
                for (Change<WlsServer> eachServerChange : serverChangesForDeploymentChange) {
                    steps.addAll(wlsServerRunBook.getModificationSteps(eachServerChange));
                }
            }
        }
        lastStepCount = steps.size();
        jmsQueueToServerMapper.generateModificationSteps(steps);
        if (steps.size() > lastStepCount) {
            this.activateChanges(steps, affectedDomains);
        }
        SqlScriptToDatabaseMapper sqlMapper = new SqlScriptToDatabaseMapper(change);
        sqlMapper.generateAdditionSteps(steps);
        lastStepCount = steps.size();
        for (WlsTarget each : newJmsTargetedServers) {
            if (oldJmsTargetedServers.contains((Object)each)) continue;
            steps.add(new CreateWlsJmsModuleStep((WlsServer)each, JmsMapperUtils.getJmsModuleName(change, each)));
        }
        for (WlsTarget each : newJmsTargetedClusters) {
            if (oldJmsTargetedClusters.contains((Object)each)) continue;
            steps.add(new CreateWlsJmsModuleStep((WlsCluster)each, JmsMapperUtils.getJmsModuleName(change, each)));
        }
        jmsServerToServerMapper.generateAdditionSteps(steps);
        jmsConnectionFactoryToClusterMapper.generateAdditionSteps(steps);
        jmsQueueToServerMapper.generateAdditionSteps(steps);
        jmsForeignServerToClusterMapper.generateAdditionSteps(steps);
        jmsForeignJmsConnectionFactoryToClusterMapper.generateAdditionSteps(steps);
        jmsForeignDestinationToClusterMapper.generateAdditionSteps(steps);
        dataSourceToClusterMapper.generateAdditionSteps(steps);
        dataSourceToServerMapper.generateAdditionSteps(steps);
        maxThreadsConstraintsToClusterMapper.generateAdditionSteps(steps);
        workManagerToClusterMapper.generateAdditionSteps(steps);
        if (steps.size() > lastStepCount) {
            this.activateChanges(steps, affectedDomains);
        }
        lastStepCount = steps.size();
        earToClusterMapper.generateDeploySteps(steps);
        earToServerMapper.generateDeploySteps(steps);
        warToClusterMapper.generateDeploySteps(steps);
        warToServerMapper.generateDeploySteps(steps);
        ejbToClusterMapper.generateDeploySteps(steps);
        ejbToServerMapper.generateDeploySteps(steps);
        libJarToClusterMapper.generateDeploySteps(steps);
        libJarToServerMapper.generateDeploySteps(steps);
        if (steps.size() > lastStepCount) {
            this.activateChanges(steps, affectedDomains);
        }
        earToClusterMapper.generateStartSteps(steps);
        earToServerMapper.generateStartSteps(steps);
        warToClusterMapper.generateStartSteps(steps);
        warToServerMapper.generateStartSteps(steps);
        ejbToClusterMapper.generateStartSteps(steps);
        ejbToServerMapper.generateStartSteps(steps);
        libJarToClusterMapper.generateStartSteps(steps);
        libJarToServerMapper.generateStartSteps(steps);
        this.restartServersRequiringRestart(steps, affectedDomains);
        staticContentMapper.generateDeletionSteps(steps);
        staticContentMapper.generateAdditionSteps(steps);
        pluginConfigMapper.generateDeletionSteps(steps);
        pluginConfigMapper.generateAdditionSteps(steps);
    }

    private boolean isWlsDeployment(Set<WlsCluster> targetClusters, Set<WlsServer> targetServers) {
        return !targetClusters.isEmpty() || !targetServers.isEmpty();
    }

    private void sortQueueMappings(WlsJmsQueueToWlsServerMapper queueMapper) {
        Collections.sort(queueMapper.getAddedMappings(), new WlqJmsQueueSorter(true));
        Collections.sort(queueMapper.getDeletedMappings(), new WlqJmsQueueSorter(false));
    }

    private void activateChanges(List<Step> steps, Set<WlsDomain> domains) {
        for (WlsDomain eachDomain : domains) {
            steps.add(new ActivatePendingChangesStep(eachDomain));
        }
    }

    private void restartServersRequiringRestart(List<Step> steps, Set<WlsDomain> domains) {
        for (WlsDomain eachDomain : domains) {
            if (!eachDomain.isUseNodeManager()) continue;
            steps.add(new RestartServersThatRequireRestartStep(eachDomain));
        }
    }

    private Set<Change<WlsServer>> findServerChangesForDeploymentChange(ChangePlan changePlan, Change<Deployment> deploymentChange, Set<WlsServer> oldTargetServers, Set<WlsServer> newTargetServers) {
        HashSet<Change<WlsServer>> serverChanges = new HashSet<Change<WlsServer>>();
        for (Change serverChange : this.getChangesForCiType(changePlan, WlsServer.class)) {
            if (!serverChange.isModification() || !oldTargetServers.contains(serverChange.getOldRevision()) || !newTargetServers.contains(serverChange.getNewRevision())) continue;
            serverChanges.add((Change<WlsServer>)serverChange);
        }
        return serverChanges;
    }

    private Set<Change> getChangesForCiType(ChangePlan cp, Class<? extends Serializable> changeTypeClass) {
        HashSet<Change> changesOfType = new HashSet<Change>();
        for (Change change : cp.getChanges()) {
            if (!changeTypeClass.equals(change.getConfigurationItemClass())) continue;
            changesOfType.add(change);
        }
        return changesOfType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WlqJmsQueueSorter
    implements Comparator<WlsServerResourceMapping> {
        private boolean errorQueuesFirst;

        public WlqJmsQueueSorter(boolean errorQueuesFirst) {
            this.errorQueuesFirst = errorQueuesFirst;
        }

        @Override
        public int compare(WlsServerResourceMapping o1, WlsServerResourceMapping o2) {
            WlsJmsQueue lhs = (WlsJmsQueue)((Object)o1.getSource());
            WlsJmsQueue rhs = (WlsJmsQueue)((Object)o2.getSource());
            int res = lhs.getErrorQueue() == null ? (rhs.getErrorQueue() == null ? 0 : 1) : (rhs.getErrorQueue() == null ? -1 : 0);
            if (res == 0) {
                res = lhs.getName().compareTo(rhs.getName());
            }
            if (this.errorQueuesFirst) {
                res = -res;
            }
            return res;
        }
    }
}

