/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.log4j.Logger;

public class WlsServerCheckReachableStep
implements Step {
    protected final WlsServer server;
    private static Logger logger = Logger.getLogger(WlsServerCheckReachableStep.class);

    public WlsServerCheckReachableStep(WlsServer server) {
        this.server = server;
    }

    public boolean execute(StepExecutionContext ctx) {
        try {
            URL wlsServerHomePageUrl = new URL(this.getServerUrl());
            HttpURLConnection con = (HttpURLConnection)wlsServerHomePageUrl.openConnection();
            con.getResponseMessage();
            return true;
        }
        catch (Exception e) {
            logger.info((Object)("Cannot reach WlsServer at " + this.getServerUrl()));
            return false;
        }
    }

    public String getDescription() {
        return "Checking reachability of Wls server" + (Object)((Object)this.server) + " on host " + this.server.getHost() + " by accessing URL " + this.getServerUrl();
    }

    private String getServerUrl() {
        return "http://" + this.server.getHost().getAddress() + ":" + this.server.getPort();
    }
}

