/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsDeploymentPlan;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.WlsStepBase;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class WlsDeployArtifactStep
extends WlsStepBase {
    private static final String DEPLOY_APPLICATION_ON_WEBLOGIC_SCRIPT_NAME = "com/xebialabs/deployit/plugin/wls/step/deploy-application.py";
    private static final String DEPLOY_APPLICATION_ON_WEBLOGIC_WITH_PLAN_SCRIPT_NAME = "com/xebialabs/deployit/plugin/wls/step/deploy-plan-application.py";
    private String targetName;
    private String applicationName;
    private String extension;
    private String applicationLocation;
    private String deploymentPlanLocation;
    private String remoteDeploymentPlanDestination;

    public WlsDeployArtifactStep(WlsTarget target, NamedDeployableArtifact artifact) {
        super(target.getDomain());
        this.targetName = target.getName();
        this.applicationName = artifact.getName();
        this.extension = this.findOutExtension(artifact);
        this.applicationLocation = artifact.getLocation();
        this.setDescription("Deploy " + artifact + " on " + (Object)((Object)target));
    }

    public String getDescription() {
        String desc = super.getDescription();
        if (this.hasDeploymentPlan()) {
            desc = desc + " and a deployment plan";
        }
        return desc;
    }

    private String findOutExtension(NamedDeployableArtifact artifact) {
        try {
            Field field = artifact.getClass().getField("ARCHIVE_EXTENSION");
            return "." + field.get(artifact).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected artifact " + artifact, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.domain.connectToAdminHost();
        try {
            String[] args;
            int res;
            HostFile uploadedApplication = this.uploadApplication(rhs);
            String uploadedApplicationPath = uploadedApplication.getPath().replace('\\', '/');
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.add(this.domain.getUsername());
            argsList.add(this.domain.getPassword());
            argsList.add(this.domain.getConnectUrl());
            argsList.add(this.targetName);
            argsList.add(this.applicationName);
            argsList.add(uploadedApplicationPath);
            String resourcePath = DEPLOY_APPLICATION_ON_WEBLOGIC_SCRIPT_NAME;
            if (this.hasDeploymentPlan()) {
                resourcePath = DEPLOY_APPLICATION_ON_WEBLOGIC_WITH_PLAN_SCRIPT_NAME;
                HostFile uploadedPan = this.uploadPlan(rhs);
                String uploadedPlanPath = uploadedPan.getPath().replace('\\', '/');
                argsList.add(uploadedPlanPath);
            }
            boolean bl = (res = this.executeWlstJythonScriptResource(ctx, rhs, resourcePath, args = argsList.toArray(new String[argsList.size()]))) == 0;
            return bl;
        }
        finally {
            rhs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostFile uploadPlan(HostSession rhs) {
        HostSession lhs = Host.getLocalHost().getHostSession();
        try {
            HostFile planFileToUpload = lhs.getFile(this.deploymentPlanLocation);
            HostFile uploadedPlanFile = rhs.getFile(this.remoteDeploymentPlanDestination);
            HostFile parentFile = uploadedPlanFile.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            HostFileUtils.copy((HostFile)planFileToUpload, (HostFile)uploadedPlanFile);
            HostFile hostFile = uploadedPlanFile;
            return hostFile;
        }
        finally {
            lhs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostFile uploadApplication(HostSession rhs) {
        HostSession lhs = Host.getLocalHost().getHostSession();
        try {
            HostFile applicationFileToUpload = lhs.getFile(this.applicationLocation);
            HostFile uploadedApplicationFile = rhs.getTempFile(this.applicationName, this.extension);
            HostFileUtils.copy((HostFile)applicationFileToUpload, (HostFile)uploadedApplicationFile);
            HostFile hostFile = uploadedApplicationFile;
            return hostFile;
        }
        finally {
            lhs.close();
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getApplicationLocation() {
        return this.applicationLocation;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setDeploymentPlan(WlsDeploymentPlan plan, String remoteDeploymentPlanDestination) {
        this.deploymentPlanLocation = plan.getLocation();
        this.remoteDeploymentPlanDestination = remoteDeploymentPlanDestination;
    }

    public boolean hasDeploymentPlan() {
        return !StringUtils.isBlank((String)this.deploymentPlanLocation) && !StringUtils.isBlank((String)this.remoteDeploymentPlanDestination);
    }
}

