/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.mapper;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.plugin.wls.ci.WlsArtifactMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsStageMode;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.WlsDeployArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WlsDeployNoStageArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WlsStepBase;
import com.xebialabs.deployit.steps.CopyStep;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WlsStageModeMapperHelper {
    public List<? extends Step> generateDeploySteps(List<WlsArtifactMapping> mappings) {
        LinkedList<WlsDeployArtifactStep> stageSteps = new LinkedList<WlsDeployArtifactStep>();
        LinkedList<WlsDeployNoStageArtifactStep> noStageSteps = new LinkedList<WlsDeployNoStageArtifactStep>();
        HashSet<CopyStep> copySteps = new HashSet<CopyStep>();
        boolean noStageModeFound = false;
        for (WlsArtifactMapping m : mappings) {
            noStageModeFound = this.isNoStageMode(m);
            if (!noStageModeFound) {
                WlsDeployArtifactStep step = new WlsDeployArtifactStep(m.getTarget(), m.getSource());
                if (m.getDeploymentPlan() != null) {
                    Host activeHost = m.getTarget().getDomain().getActiveHost();
                    String remoteDeploymentPlanDestination = m.getDeploymentPlanStagingDirectory() + activeHost + m.getSource().getName() + ".xml";
                    if (StringUtils.isBlank((String)m.getDeploymentPlanStagingDirectory())) {
                        throw new IllegalArgumentException("With a deployment plan, a deployment plan staging directory must be filled.");
                    }
                    step.setDeploymentPlan(m.getDeploymentPlan(), remoteDeploymentPlanDestination);
                }
                stageSteps.add(step);
                continue;
            }
            String remoteDestination = "";
            String remoteDeploymentPlanDestination = "";
            for (Host remoteHost : this.findHosts(m.getTarget())) {
                String separator = remoteHost.getFileSeparator();
                if (StringUtils.isBlank((String)m.getStagingDirectory())) {
                    throw new IllegalArgumentException("With noStage Mode, a staging directory must be filled.");
                }
                remoteDestination = m.getStagingDirectory() + separator + m.getSource().getName() + "." + this.getExtension(m.getSource());
                copySteps.add(new CopyStep(Host.getLocalHost(), m.getSource().getLocation(), remoteHost, remoteDestination, true));
                if (m.getDeploymentPlan() == null) continue;
                if (StringUtils.isBlank((String)m.getDeploymentPlanStagingDirectory())) {
                    throw new IllegalArgumentException("With a deployment plan, a deployment plan staging directory must be filled.");
                }
                remoteDeploymentPlanDestination = m.getDeploymentPlanStagingDirectory() + separator + m.getSource().getName() + ".xml";
                copySteps.add(new CopyStep(Host.getLocalHost(), m.getDeploymentPlan().getLocation(), remoteHost, remoteDeploymentPlanDestination, true));
            }
            WlsDeployNoStageArtifactStep step = new WlsDeployNoStageArtifactStep(m.getTarget(), m.getSource(), remoteDestination);
            if (m.getDeploymentPlan() != null) {
                step.setRemoteDeploymentPlanPath(remoteDeploymentPlanDestination);
            }
            noStageSteps.add(step);
        }
        ArrayList<WlsStepBase> allSteps = new ArrayList<WlsStepBase>();
        allSteps.addAll(stageSteps);
        allSteps.addAll(copySteps);
        allSteps.addAll(noStageSteps);
        return allSteps;
    }

    private String getExtension(NamedDeployableArtifact artifact) {
        try {
            Field field = artifact.getClass().getField("ARCHIVE_EXTENSION");
            return "." + field.get(artifact).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected artifact " + artifact, e);
        }
    }

    private Set<Host> findHosts(WlsTarget target) {
        HashSet<Host> hosts = new HashSet<Host>();
        if (target instanceof WlsServer) {
            WlsServer server = (WlsServer)target;
            hosts.add(server.getHost());
        }
        if (target instanceof WlsCluster) {
            WlsCluster cluster = (WlsCluster)target;
            for (WlsServer server : cluster.getServers()) {
                hosts.add(server.getHost());
            }
        }
        return hosts;
    }

    private boolean isNoStageMode(WlsArtifactMapping artefactMapping) {
        WlsTarget target = artefactMapping.getTarget();
        if (target instanceof WlsCluster) {
            return artefactMapping.getStageMode().equals((Object)WlsStageMode.NoStage);
        }
        if (target instanceof WlsServer) {
            WlsServer server = (WlsServer)target;
            return server.getStageMode().equals((Object)WlsStageMode.NoStage) || artefactMapping.getStageMode().equals((Object)WlsStageMode.NoStage);
        }
        return artefactMapping.getStageMode().equals((Object)WlsStageMode.NoStage);
    }
}

