/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckWlsClusterMemberNamesStep
implements Step {
    private WlsCluster cluster;
    private Set<String> serverNames;
    private String additionalMessage;

    public CheckWlsClusterMemberNamesStep(WlsCluster cluster, Set<String> serverNames) {
        this.cluster = cluster;
        this.serverNames = serverNames;
        this.additionalMessage = null;
    }

    public boolean execute(StepExecutionContext ctx) {
        String containmentpath = "/Clusters/" + this.cluster.getName() + "/Servers";
        Map<String, String> objectOnfo = this.cluster.getDomain().getDirectoryObjectInfo(containmentpath);
        if (objectOnfo.keySet().size() != this.serverNames.size()) {
            StringBuilder sb = new StringBuilder();
            for (String foundServerName : objectOnfo.keySet()) {
                if (this.serverNames.contains(foundServerName)) continue;
                String serverContainmentpath = "/Servers/" + foundServerName;
                Map<String, String> serverObjectOnfo = this.cluster.getDomain().getObjectInfo(serverContainmentpath);
                String port = serverObjectOnfo.get("ListenPort");
                sb.append("\nfound unknown server: " + foundServerName + " on port " + port + "\n");
            }
            for (String previouslyKnownServerName : this.serverNames) {
                if (objectOnfo.keySet().contains(previouslyKnownServerName)) continue;
                sb.append("\ncan't find server named: " + previouslyKnownServerName + " on cluster: " + (Object)((Object)this.cluster) + "\n");
            }
            this.additionalMessage = sb.toString();
            return false;
        }
        return true;
    }

    public String getDescription() {
        String result = "Check the list of servers in WebLogic cluster \"" + this.cluster.getLabel() + "\" on domain \"" + (Object)((Object)this.cluster.getDomain()) + "\"";
        if (this.additionalMessage != null) {
            result = result + this.additionalMessage;
            this.additionalMessage = null;
        }
        return result;
    }
}

