import sys
import os
import time as ptime

sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)

name = sys.argv.pop(0)
domain = sys.argv.pop(0)
targetName = sys.argv.pop(0)
threadcount = int(sys.argv.pop(0))
notes = sys.argv.pop(0)

#====================================#
# Create Maximum Threads Constraint  #
#====================================#
def createMaximumThreadsConstraint(name, domainName, targetname, threadcount, notes):
  log('Create maximum thread constraints '+name)
  targetArray = getClusterServerTargetArray(targetname)
  cd('/SelfTuning/' + domainName + '/MaxThreadsConstraints')
  cmo.createMaxThreadsConstraint(name)
  cd('/SelfTuning/' + domainName + '/MaxThreadsConstraints/' + name)
  set('Count', threadcount)
  set('Notes', notes) 
  set('Targets', targetArray)
  return
  
#=====================================#
# Get ClustServer Target Array        #
#=====================================#
def getClusterServerTargetArray(targetlist):
    objectArray=[];
    targets=targetlist.split( "," )
    for target in targets:
        bean=getMBean( '/Servers/'+target )
        if bean != None :
            objectArray.append( ObjectName('com.bea:Name=' + bean.getName() + ',Type='+bean.getType()) )
        bean=getMBean( '/Clusters/'+target )
        if bean != None :
            objectArray.append( ObjectName('com.bea:Name=' + bean.getName() + ',Type='+bean.getType()) )
    if objectArray :
        targetArray = jarray.array(objectArray, ObjectName)
    else :
        raise ValueError('Not targets found for '+targetlist )             
    return targetArray

#==============================#
# Logging method               #
#==============================#
def log(msg, level="info"):
    print ptime.strftime("%H:%M:%S", ptime.localtime()) + " <" + level + "> " + msg
    return
    
    
#==============================#
# Entry Point                  #
#==============================#
connect(user, password, url)
edit()
startEdit()
createMaximumThreadsConstraint(name, domain, targetName, threadcount, notes)
save()
disconnect('true')
exit('y')
