import sys
import os
import time as ptime

ignore = sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)

targetname = sys.argv.pop(0)

name = sys.argv.pop(0)
jndiName = sys.argv.pop(0)
uri = sys.argv.pop(0)
dbUser = sys.argv.pop(0)
dbPassword = sys.argv.pop(0)
driver = sys.argv.pop(0)
initialCapacity = sys.argv.pop(0)
maxCapacity = sys.argv.pop(0)
properties = sys.argv.pop(0)


#====================================#
# Create JDBC Source                 #
#====================================#
def createJDBCsource(name, jndiName, uri, dbUser, dbPassword, driver, targetname, initialCapacity, maxCapacity, properties):
  """Create a JDBC datasource 
  Keyword arguments:
  name -- The name of the datasource
  jndiName -- the JNDI name of the datasource
  uri -- The JDBC uri to the database
  dbUser  -- The dbUser credential for the database
  dbPassword -- The dbPassword credential for the database
  driver -- The driver of the datasource, the classname
  targetname -- The server or clustername to which to target the datasource
  init -- The initial connectionpool size
  max -- The maximum connectionpool size
  properties -- A comma separated list of name=value properties
  """
  log('Creating JDBC resource '+name)
  cd("/")
  cmo.createJDBCSystemResource(name)
  cd("/JDBCSystemResources/" + name + "/JDBCResource/"+ name)
  set("Name", name)
  cd("/JDBCSystemResources/" + name + "/JDBCResource/"+ name +"/JDBCDataSourceParams/" + name)
  set('JNDINames',jarray.array([String(jndiName)], String))
  set('GlobalTransactionsProtocol', 'TwoPhaseCommit')
  cd("/JDBCSystemResources/" + name + "/JDBCResource/"+ name +"/JDBCDriverParams/" + name)
  set("Url", uri)
  set("DriverName", driver)
  #set('PasswordEncrypted', dbPassword)
  set('Password', dbPassword)
  cd("/JDBCSystemResources/" + name + "/JDBCResource/"+ name +"/JDBCConnectionPoolParams/" + name)
  set("InitialCapacity", initialCapacity)
  set("MaxCapacity", maxCapacity)
  set("TestTableName", "SQL SELECT 1 FROM DUAL")

  cd("/JDBCSystemResources/" + name + "/JDBCResource/" + name + "/JDBCDriverParams/" + name + "/Properties/" + name)
  cmo.createProperty('user')
  cd("/JDBCSystemResources/" + name + "/JDBCResource/" + name + "/JDBCDriverParams/" + name + "/Properties/" + name + "/Properties/user")
  set("Value", dbUser)
  cd("/JDBCSystemResources/" + name + "/JDBCResource/" + name + "/JDBCConnectionPoolParams/" + name )
  set('TestConnectionsOnReserve', 'true')
  
  properties=properties.split(",")
  for prop in properties:
    if(len(prop.split("=")) == 2):
      key=prop.split("=")[0]
      val=prop.split("=")[1]
      cd("/JDBCSystemResources/" + name + "/JDBCResource/" + name + "/JDBCDriverParams/" + name + "/Properties/" + name)
      cmo.createProperty(key)
      cd("/JDBCSystemResources/" + name + "/JDBCResource/" + name + "/JDBCDriverParams/" + name + "/Properties/" + name + "/Properties/"+key)
      set("Value", val)
  
  cd("/JDBCSystemResources/" + name + "/JDBCResource/" + name + "/JDBCDriverParams/" + name)
  set("Url", uri)
  cd('/')
  try:
    target = lookup(targetname, 'Server')
    print "Server choosen: "+targetname
  except WLSTException, reason:
    print "No server named "+targetname
  try: 
    target = lookup(targetname, 'Cluster')
    print "Cluster choosen: "+targetname
  except WLSTException, reason:
    print "No cluster named "+targetname
  cd("/JDBCSystemResources/" + name)
  set('Targets', jarray.array([ObjectName('com.bea:Name=' + target.getName() + ',Type='+target.getType())], ObjectName) )
  return



#==============================#
# Logging method               #
#==============================#
def log(msg, level="info"):
  print ptime.strftime("%H:%M:%S", ptime.localtime()) + " <" + level + "> " + msg
  return
  

  
connect(user, password, url)
edit()
startEdit()

createJDBCsource(name, jndiName, uri, dbUser, dbPassword, driver, targetname, initialCapacity, maxCapacity, properties)

save()
disconnect('true')
exit('y')

