package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Undeploys a deployed {@link NamedDeployableArtifact application}.
 */
@SuppressWarnings("serial")
public class WlsUndeployArtifactStep extends SimpleWlstExecutingStep {

	private static final String SCRIPT_NAME = STEP_RESOURCES_PATH + "undeploy-application.py";

	public WlsUndeployArtifactStep(WlsServer server, Ear application) {
		super("Undeploy EAR " + application + " from Domain " + server.getDomain() + " and Server " + server, server.getDomain(), SCRIPT_NAME,
				server.getName(), application.getName());
	}

	public WlsUndeployArtifactStep(WlsCluster cluster, Ear application) {
		super("Undeploy EAR " + application + " from Domain " + cluster.getDomain() + " and Cluster " + cluster, cluster.getDomain(), SCRIPT_NAME, cluster
				.getName(), application.getName());
	}

	public WlsUndeployArtifactStep(WlsServer server, War application) {
		super("Undeploy WAR " + application + " from Domain " + server.getDomain() + " and Server " + server, server.getDomain(), SCRIPT_NAME,
				server.getName(), application.getName());
	}

	public WlsUndeployArtifactStep(WlsCluster cluster, War application) {
		super("Undeploy WAR " + application + " from Domain " + cluster.getDomain() + " and Cluster " + cluster, cluster.getDomain(), SCRIPT_NAME, cluster
				.getName(), application.getName());
	}

	public WlsUndeployArtifactStep(WlsServer server, EjbJar application) {
		super("Undeploy EJB " + application + " from Domain " + server.getDomain() + " and Server " + server, server.getDomain(), SCRIPT_NAME,
				server.getName(), application.getName());
	}

	public WlsUndeployArtifactStep(WlsCluster cluster, EjbJar application) {
		super("Undeploy EJB " + application + " from Domain " + cluster.getDomain() + " and Cluster " + cluster, cluster.getDomain(), SCRIPT_NAME, cluster
				.getName(), application.getName());
	}

}
