package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Deploys applications on a {@link WlsCluster cluster} or {@link WlsServer managed server}.
 */
@SuppressWarnings("serial")
public class WlsDeployArtifactStep extends WlsStepBase {

	public static final String EAR_EXTENSION = ".ear";

	public static final String WAR_EXTENSION = ".war";

	public static final String EJB_JAR_EXTENSION = ".jar";

	private static final String DEPLOY_APPLICATION_ON_WEBLOGIC_SCRIPT_NAME = STEP_RESOURCES_PATH + "deploy-application.py";

	private String targetName;

	private String applicationName;

	private String extension;

	private String applicationLocation;

	public WlsDeployArtifactStep(WlsCluster cluster, Ear application) {
		super(cluster.getDomain());
		this.targetName = cluster.getName();
		this.applicationName = application.getName();
		this.extension = EAR_EXTENSION;
		this.applicationLocation = application.getLocation();
		setDescription("Deploy EAR " + application + " on cluster " + cluster);
	}

	public WlsDeployArtifactStep(WlsServer server, Ear application) {
		super(server.getDomain());
		this.targetName = server.getName();
		this.applicationName = application.getName();
		this.extension = EAR_EXTENSION;
		this.applicationLocation = application.getLocation();
		setDescription("Deploy EAR " + application + " on server " + server);
	}

	public WlsDeployArtifactStep(WlsCluster cluster, War application) {
		super(cluster.getDomain());
		this.targetName = cluster.getName();
		this.applicationName = application.getName();
		this.extension = WAR_EXTENSION;
		this.applicationLocation = application.getLocation();
		setDescription("Deploy WAR " + application + " on cluster " + cluster);
	}

	public WlsDeployArtifactStep(WlsServer server, War application) {
		super(server.getDomain());
		this.targetName = server.getName();
		this.applicationName = application.getName();
		this.extension = WAR_EXTENSION;
		this.applicationLocation = application.getLocation();
		setDescription("Deploy WAR " + application + " on server " + server);
	}

	public WlsDeployArtifactStep(WlsCluster cluster, EjbJar application) {
		super(cluster.getDomain());
		this.targetName = cluster.getName();
		this.applicationName = application.getName();
		this.extension = EJB_JAR_EXTENSION;
		this.applicationLocation = application.getLocation();
		setDescription("Deploy EJB " + application + " on cluster " + cluster);
	}

	public WlsDeployArtifactStep(WlsServer server, EjbJar application) {
		super(server.getDomain());
		this.targetName = server.getName();
		this.applicationName = application.getName();
		this.extension = EJB_JAR_EXTENSION;
		this.applicationLocation = application.getLocation();
		setDescription("Deploy EJB " + application + " on server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = domain.connectToAdminHost();
		try {
			HostFile uploadedApplication = uploadApplication(rhs);
			String uploadedApplicationPath = uploadedApplication.getPath().replace('\\', '/');

			List<String> argsList = new ArrayList<String>();
			argsList.add(domain.getUsername());
			argsList.add(domain.getPassword());
			argsList.add(domain.getConnectUrl());
			argsList.add(targetName);
			argsList.add(applicationName);
			argsList.add(uploadedApplicationPath);
			String[] args = argsList.toArray(new String[argsList.size()]);

			int res = executeWlstJythonScriptResource(ctx, rhs, DEPLOY_APPLICATION_ON_WEBLOGIC_SCRIPT_NAME, args);
			return res == 0;
		} finally {
			rhs.close();
		}
	}

	private HostFile uploadApplication(HostSession rhs) {
		HostFile uploadedApplicationFile;
		HostSession lhs = HostSessionFactory.getHostSession(Host.getLocalHost());
		HostFile applicationFileToUpload = lhs.getFile(applicationLocation);
		try {
			uploadedApplicationFile = rhs.getTempFile(applicationName, extension);
			HostFileUtils.copy(applicationFileToUpload, uploadedApplicationFile);
		} finally {
			lhs.close();
		}
		return uploadedApplicationFile;
	}

	public String getApplicationName() {
		return applicationName;
	}

	public String getExtension() {
		return extension;
	}

	public String getApplicationLocation() {
		return applicationLocation;
	}

	public String getTargetName() {
		return targetName;
	}

}
