package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsMaximumThreadsConstraint;

/**
 * Deletes a {@link WlsMaximumThreadsConstraint maximum thread constraint}.
 */
@SuppressWarnings("serial")
public class DestroyWlsMaximumThreadsContraintStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "destroy-maximum-threads-constraint.py";

	public DestroyWlsMaximumThreadsContraintStep(WlsMaximumThreadsConstraint constraint, WlsDomain domain) {
		super("Destroy Maximum Thread Constraint " + constraint, domain, SCRIPT_RESOURCE_PATH, getArgs(constraint, domain));
	}

	private static String[] getArgs(WlsMaximumThreadsConstraint threadConstraint, WlsDomain domain) {
		List<String> args = new ArrayList<String>();
		args.add(domain.getName());
		args.add(threadConstraint.getName());
		return args.toArray(new String[args.size()]);
	}

}
