package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Deletes a {@link WlsJmsQueue JMS queue}.
 */
@SuppressWarnings("serial")
public class DestroyWlsJmsQueueStep extends SimpleWlstExecutingStep {

	public static final String STRING = STEP_RESOURCES_PATH + "destroy-jms-queue.py";

	public DestroyWlsJmsQueueStep(WlsServer server, WlsJmsQueue queue) {
		super("Destroy WebLogic Queue " + queue + " on server " + server + " in module " + queue.getParentModule().getName(), server.getDomain(),
				STRING, queue.getParentModule().getName(), queue.getName(), server.getName());
	}

}