package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsConnectionFactory;

/**
 * Deletes a {@link WlsJmsConnectionFactory JMS connection factory}.
 */
@SuppressWarnings("serial")
public class DestroyWlsJmsConnectionFactoryStep extends SimpleWlstExecutingStep {

	public static final String STRING = STEP_RESOURCES_PATH + "destroy-jms-connection-factory.py";

	public DestroyWlsJmsConnectionFactoryStep(WlsDomain domain, WlsJmsConnectionFactory connectionFactory) {
		super("Destroy connection factory " + connectionFactory + " in domain " + domain, domain, STRING, connectionFactory.getParentJmsModule().getName(),
				connectionFactory.getName());
	}

}
