package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.wls.ci.ApacheHttpdWlsPluginConfiguration;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Deletes a configuration for the Apache WebLogic plugin.
 */
@SuppressWarnings("serial")
public class DestroyApacheHttpdWlsPluginConfigFileStep extends ApacheWlsPluginConfigFileStep {

	public DestroyApacheHttpdWlsPluginConfigFileStep(ApacheHttpdServer webServer, ApacheHttpdWlsPluginConfiguration pluginConfiguration, WlsCluster cluster,
			String virtualHost) {
		super(webServer, pluginConfiguration, cluster, virtualHost);
		setDescription("Destroy Weblogic Apache Plugin configuration file on " + webServer.getHost());
	}

	public DestroyApacheHttpdWlsPluginConfigFileStep(ApacheHttpdServer webServer, ApacheHttpdWlsPluginConfiguration pluginConfiguration, WlsServer server,
			String virtualHost) {
		super(webServer, pluginConfiguration, server, virtualHost);
		setDescription("Destroy Weblogic Apache Plugin configuration file on " + webServer.getHost());
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession hostSession = webServer.connectToAdminHost();
		try {
			ctx.logOutput("Destroying Apache Weblogic configuration file at " + wlConfigFilePath);

			HostFile apacheWlConfFile = hostSession.getFile(wlConfigFilePath);
			apacheWlConfFile.delete();
			return true;
		} finally {
			hostSession.close();
		}
	}

}
