package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsMaximumThreadsConstraint;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Creates a {@link WlsMaximumThreadsConstraint maximum thread constraint}.
 */
@SuppressWarnings("serial")
public class CreateWlsMaximumThreadConstraintStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-maximum-threads-constraint.py";

	public CreateWlsMaximumThreadConstraintStep(WlsMaximumThreadsConstraint maximumThreadsConstraint, WlsDomain domain, Set<WlsCluster> clusters) {
		super("Create Maximum Threads Constraint " + maximumThreadsConstraint + " in domain " + domain, domain, SCRIPT_RESOURCE_PATH, getArgs(
				maximumThreadsConstraint, domain, clusters));
	}

	private static String[] getArgs(WlsMaximumThreadsConstraint threadConstraint, WlsDomain domain, Set<WlsCluster> clusters) {
		List<String> args = new ArrayList<String>();
		args.add(threadConstraint.getName());
		args.add(domain.getName());
		args.add(ExtendedStringUtils.join(clusters, WlsCluster.TOSTRING_FROM_NAME));
		args.add(String.valueOf(threadConstraint.getThreadCount()));
		args.add(threadConstraint.getNotes());
		return args.toArray(new String[args.size()]);
	}

}
