package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsModule;

/**
 * Creates a {@link WlsJmsServer foreign JMS server}.
 */
@SuppressWarnings("serial")
public class CreateWlsJmsServersStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-jms-server.py";

	public CreateWlsJmsServersStep(WlsCluster cluster, List<WlsServer> servers, List<WlsJmsServer> jmsServers, WlsJmsModule module) {
		this(cluster.getDomain().getActiveHost(), cluster.getDomain(), module.getName(), cluster, servers, jmsServers);
	}

	public CreateWlsJmsServersStep(Host domainHost, WlsDomain domain, String moduleName, WlsCluster cluster, List<WlsServer> servers,
			List<WlsJmsServer> jmsServers) {
		super("Create JMS Servers for cluster " + cluster + " in domain " + domain, domain, SCRIPT_RESOURCE_PATH, getArgs(moduleName, cluster, servers,
				jmsServers));
	}

	private static String[] getArgs(String moduleName, WlsCluster cluster, List<WlsServer> servers, List<WlsJmsServer> jmsServers) {
		List<String> args = new ArrayList<String>();
		args.add(moduleName);
		args.add(cluster.getName());
		for (int i = 0; i < servers.size(); i++) {
			WlsServer server = servers.get(i);
			WlsJmsServer jmsServer = jmsServers.get(i);
			args.add(server.getName());
			args.add(jmsServer.getName());
			args.add(jmsServer.getName() + "-filestore");
			args.add(jmsServer.getFileStorePath());
			args.add(jmsServer.getName() + "-subdeployment");

		}
		return args.toArray(new String[args.size()]);
	}

}
