package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.plugin.wls.WlsConventions;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsModule;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Creates a {@link WlsJmsModule JMS module}.
 */
@SuppressWarnings("serial")
public class CreateWlsJmsModuleStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-jms-module.py";

	public CreateWlsJmsModuleStep(WlsCluster cluster, WlsJmsModule module) {
		super("Create JMS Module " + module + " for cluster " + cluster + " in domain " + cluster.getDomain(), cluster.getDomain(), SCRIPT_RESOURCE_PATH,
				getArgs(module, cluster));
	}

	private static String[] getArgs(WlsJmsModule module, WlsCluster cluster) {
		List<String> args = new ArrayList<String>();
		args.add(module.getName());
		String jmsServerPrefix = createJMServerPrefix(module.getName());
		args.add(cluster.getName());

		/*
		 * XXX: Why a method that has only one line? Collections.sort(servers, new BeanComparator("name") says exactly the same thing.
		 */
		List<WlsServer> sortedServers = WlsServer.toNameSortedList(cluster.getServers());
		for (int i = 0; i < sortedServers.size(); i++) {
			WlsServer server = sortedServers.get(i);
			int jmsServerIndex = i + 1;
			String jmsServerName = jmsServerPrefix + "-JMSServer_" + jmsServerIndex;
			String jmsFileStoreName = jmsServerPrefix + "-JMSFileStore_" + jmsServerIndex;
			args.add(server.getName());
			args.add(jmsServerName);
			args.add(jmsFileStoreName);
			args.add(WlsConventions.getFilestorePath(cluster.getDomain()));
			args.add(jmsServerName + "-subdeployment");

		}
		return args.toArray(new String[args.size()]);
	}

	protected static String createJMServerPrefix(String moduleName) {
		return StringUtils.remove(moduleName, "-JMSModule");
	}

}
