package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsConnectionFactory;

/**
 * Creates a {@link WlsJmsConnectionFactory JMS connection factory}.
 */
@SuppressWarnings("serial")
public class CreateWlsJmsConnectionFactoryStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-jms-connection-factory.py";

	public CreateWlsJmsConnectionFactoryStep(WlsDomain domain, WlsJmsConnectionFactory connectionFactory) {
		super("Create connection factory " + connectionFactory + " in domain " + domain, domain, SCRIPT_RESOURCE_PATH, getArgs(connectionFactory));
	}

	private static String[] getArgs(WlsJmsConnectionFactory connectionFactory) {
		return new String[] { connectionFactory.getName(), connectionFactory.getJndiName(), connectionFactory.getParentJmsModule().getName() };
	}

}
