package com.xebialabs.deployit.plugin.wls.step;

import java.util.Set;

import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.wls.ci.ApacheHttpdWlsPluginConfiguration;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.util.ExtendedStringUtils;

@SuppressWarnings("serial")
public abstract class ApacheWlsPluginConfigFileStep implements Step {
	protected static final String DEFAULT_WL_APACHE_VHOST_TEMPLATE = WlsStepBase.STEP_RESOURCES_PATH + "apache_wl_conf_template.vm";
	
	protected ApacheHttpdServer webServer;
	protected ApacheHttpdWlsPluginConfiguration pluginConfiguration;
	protected String virtualHost;
	protected String virtualHostServerName;
	protected String virtualHostPort;
	protected boolean usingVirtualHost;
	protected WlsServer wlServer;
	protected WlsCluster cluster;

	protected String pluginConfigLocation;
	protected String wlConfigFilePath;
	protected String clusterSpecification;

	protected String description;
	
	protected ApacheWlsPluginConfigFileStep(ApacheHttpdServer webServer, ApacheHttpdWlsPluginConfiguration pluginConfiguration, WlsServer wlServer,
			String virtualHost) {
		this(webServer, pluginConfiguration, virtualHost);
		this.wlServer = wlServer;
		init();				
	}

	protected ApacheWlsPluginConfigFileStep(ApacheHttpdServer webServer, ApacheHttpdWlsPluginConfiguration pluginConfiguration, WlsCluster cluster,
			String virtualHost) {
		this(webServer, pluginConfiguration, virtualHost);
		this.cluster = cluster;
		init();				
	}
	
	private ApacheWlsPluginConfigFileStep(ApacheHttpdServer webServer, ApacheHttpdWlsPluginConfiguration pluginConfiguration, String virtualHost) {
		if (StringUtils.isBlank(pluginConfiguration.getMimeMatchExpressions()) && StringUtils.isBlank(pluginConfiguration.getPathExpressions())) {
			throw new ResolutionException("Both Mime Match Expression and Path Expression can't be left blank");
		}
		this.pluginConfiguration = pluginConfiguration;
		this.virtualHost = virtualHost;
		usingVirtualHost = StringUtils.isNotEmpty(virtualHost);
		if (usingVirtualHost) {
			if (virtualHost.indexOf(':') > -1) {
				virtualHostServerName = virtualHost.substring(0, virtualHost.indexOf(':'));
				virtualHostPort = virtualHost.substring(virtualHost.indexOf(':') + 1);
			} else {
				throw new ResolutionException("Virtual host property " + virtualHost + ", syntax incorrect, expecting <HOSTNAME:PORT>");
			}
		}
		this.webServer = webServer;
	}

	private void init() {
		assert cluster != null || wlServer != null : "At least a cluster or server is expected";
		if (usingVirtualHost) {
			wlConfigFilePath = webServer.getConfFilePathForVirtualHost(virtualHost);
		} else {
			// XXX: assumes that this does not contain any invalid characters!
			String clusterOrServerName = isTargetCluster() ? cluster.getName() : wlServer.getName();
			wlConfigFilePath = webServer.getConfigurationLocation() + webServer.getHost().getOperatingSystemFamily().getFileSeparator() 
							   + "wls_" + clusterOrServerName + ".conf";
		}
		pluginConfigLocation = System.getProperty("java.io.tmpdir") + Host.getLocalHost().getFileSeparator() + wlConfigFilePath;
		clusterSpecification = getCommaSeparatedIpPortList(cluster.getServers());
	}

	protected String getCommaSeparatedIpPortList(Set<WlsServer> wlServers) {
		return ExtendedStringUtils.join(wlServers, new Transformer() {
			public String transform(Object obj) {
				WlsServer server = (WlsServer) obj;
				return server.getHost().getAddress() + ":" + server.getPort();
			}
		});

	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	public String getWlConfigFileName() {
		return wlConfigFilePath;
	}

	public String getPluginConfigLocation() {
		return pluginConfigLocation;
	}

	private boolean isTargetCluster() {
		return (cluster != null);
	}

}
