package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;

/**
 * Activates pending changes in a {@link WlsDomain domain}. If there are no changes pending or there is no open &quot;edit session&quot; this step has no
 * effect.
 */
@SuppressWarnings("serial")
public class ActivatePendingChangesStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "activate-changes.py";

	public ActivatePendingChangesStep(WlsDomain weblogicDomain) {
		super("Activating pending changes in WebLogic domain " + weblogicDomain, weblogicDomain, SCRIPT_RESOURCE_PATH);
	}

}
