package com.xebialabs.deployit.plugin.wls.runbook;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ChangeResolution;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;

public abstract class WlsSingleTypeHandlingRunBook<T extends Serializable> implements RunBook {

	private Class<?> ciType;

	public WlsSingleTypeHandlingRunBook(Class<?> ciType) {
		this.ciType = ciType;
	}

	public Collection<ChangeResolution> resolve(ChangePlan changePlan) {
		Collection<ChangeResolution> crs = new ArrayList<ChangeResolution>();
		for (Change<?> eachChange : changePlan.getChanges()) {
			Class<?> ciTypeOfChange = eachChange.getConfigurationItemClass();
			if (ciTypeOfChange.equals(ciType)) {
				ChangeResolution cr = new ChangeResolution(eachChange);
				List<Step> steps = new ArrayList<Step>();
				resolve(changePlan, (Change<T>) eachChange, steps);
				if (steps.size() > 0) {
					cr.addSteps(steps);
					crs.add(cr);
				}
			}
		}
		return crs;
	}

	protected abstract void resolve(ChangePlan changePlan, Change<T> change, List<Step> steps);

}
