package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.Collections;
import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsMaximumThreadsConstraint;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsMaximumThreadConstraintStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsMaximumThreadsContraintStep;

public class WlsMaximumThreadsConstraintToWlsClusterMapper extends MappingAgnosticStepGeneratingMapper<WlsMaximumThreadsConstraint, WlsCluster> {

	public WlsMaximumThreadsConstraintToWlsClusterMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WlsMaximumThreadsConstraint newSource, WlsCluster newTarget, List<Step> steps) {
		steps.add(new CreateWlsMaximumThreadConstraintStep(newSource, newTarget.getDomain(), Collections.singleton(newTarget)));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WlsMaximumThreadsConstraint oldSource, WlsCluster oldTarget, List<Step> steps) {
		steps.add(new DestroyWlsMaximumThreadsContraintStep(oldSource, oldTarget.getDomain()));
	}

}
