package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsForeignJmsServer;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsForeignJmsServerStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsForeignJmsServerStep;

public class WlsForeignServerToWlsClusterMapper extends MappingAgnosticStepGeneratingMapper<WlsForeignJmsServer, WlsCluster> {

	public WlsForeignServerToWlsClusterMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WlsForeignJmsServer newSource, WlsCluster newTarget, List<Step> steps) {
		steps.add(new CreateWlsForeignJmsServerStep(newTarget.getDomain(), newSource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WlsForeignJmsServer oldSource, WlsCluster oldTarget, List<Step> steps) {
		steps.add(new DestroyWlsForeignJmsServerStep(oldTarget.getDomain(), oldSource));
	}

}
