package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.mapping.EjbJarMapping;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.mapper.Pair;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.step.StartApplicationStep;
import com.xebialabs.deployit.plugin.wls.step.StopApplicationStep;
import com.xebialabs.deployit.plugin.wls.step.WlsDeployArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WlsUndeployArtifactStep;

public class EjbToWlsClusterMapper extends Mapper<EjbJar, EjbJarMapping, WlsCluster> {

	public EjbToWlsClusterMapper(Change<Deployment> c) {
		super(c);
	}

	public void generateUndeploySteps(List<Step> steps) {
		for (EjbJarMapping m : getDeletedMappings()) {
			steps.add(new StopApplicationStep((WlsCluster) m.getTarget(), (EjbJar) m.getSource()));
			steps.add(new WlsUndeployArtifactStep((WlsCluster) m.getTarget(), (EjbJar) m.getSource()));
		}
		for (Pair<EjbJarMapping, EjbJarMapping> mPair : getModifiedMappings()) {
			steps.add(new StopApplicationStep((WlsCluster) mPair.getFirst().getTarget(), (EjbJar) mPair.getFirst().getSource()));
			steps.add(new WlsUndeployArtifactStep((WlsCluster) mPair.getFirst().getTarget(), (EjbJar) mPair.getFirst().getSource()));
		}
	}

	public void generateDeploySteps(List<Step> steps) {
		for (Pair<EjbJarMapping, EjbJarMapping> mPair : getModifiedMappings()) {
			steps.add(new WlsDeployArtifactStep((WlsCluster) mPair.getSecond().getTarget(), (EjbJar) mPair.getSecond().getSource()));
		}
		for (EjbJarMapping m : getAddedMappings()) {
			steps.add(new WlsDeployArtifactStep((WlsCluster) m.getTarget(), (EjbJar) m.getSource()));
		}
	}

	public void generateStartSteps(List<Step> steps) {
		for (Pair<EjbJarMapping, EjbJarMapping> mPair : getModifiedMappings()) {
			steps.add(new StartApplicationStep((WlsCluster) mPair.getSecond().getTarget(), (EjbJar) mPair.getSecond().getSource()));
		}
		for (EjbJarMapping m : getAddedMappings()) {
			steps.add(new StartApplicationStep((WlsCluster) m.getTarget(), (EjbJar) m.getSource()));
		}
	}

}
