package com.xebialabs.deployit.plugin.wls.ci;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.apache.commons.beanutils.BeanComparator;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.ci.Host;

/**
 * A WLS server (Managed or admin) in a {@link WlsDomain WLS domain}.
 * 
 * @see WlsCluster
 * @see WlsDomain
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A standard Weblogic Server")
public class WlsServer extends BaseConfigurationItem {

	@ConfigurationItemProperty(required = true, description = "Name of the WebLogic Server")
	private String name;

	@ConfigurationItemProperty(required = true, description = "Port for the WebLogic Server")
	private int port;

	@ConfigurationItemProperty(required = false, description = "Classpath entries for this deployment.")
	private String classpath;

	@ConfigurationItemProperty(required = false, description = "Boot classpath entries for this deployment.")
	private String bootClasspath;

	@ConfigurationItemProperty(required = false, description = "Initial heap size to be allocated to the JVM (in megabytes).")
	private int initHeapSize;

	@ConfigurationItemProperty(required = false, description = "Maximum heap size to be allocated to the JVM (in megabytes).")
	private int maxHeapSize;

	@ConfigurationItemProperty(required = false, description = "The arguments to use when starting this server.", size = Size.LARGE)
	private String arguments;

	@ConfigurationItemProperty(required = false, description = "Absolute path of log file. Example; /opt/bea/user_projects/domain/managedserver1/ms1.log")
	private String logFileLocation;

	@ConfigurationItemProperty(required = false, description = "Enable JVM StdOut to Server Log file")
	private boolean enableJVMLogRedirection = false;

	@ConfigurationItemProperty
	private WlsDomain domain;

	@ConfigurationItemProperty
	private Host host;

	@SuppressWarnings("unchecked")
	public static List<WlsServer> toNameSortedList(Set<WlsServer> servers) {
		List<WlsServer> nameSortedServers = new ArrayList<WlsServer>(servers);
		Collections.sort(nameSortedServers, new BeanComparator("name"));
		return nameSortedServers;
	}

	public WlsDomain getDomain() {
		return domain;
	}

	public void setDomain(WlsDomain domain) {
		this.domain = domain;
	}

	public Host getHost() {
		return host;
	}

	public void setHost(Host host) {
		this.host = host;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public String getClasspath() {
		return classpath;
	}

	public void setClasspath(String classpath) {
		this.classpath = classpath;
	}

	public String getBootClasspath() {
		return bootClasspath;
	}

	public void setBootClasspath(String bootClasspath) {
		this.bootClasspath = bootClasspath;
	}

	public int getInitHeapSize() {
		return initHeapSize;
	}

	public void setInitHeapSize(int initHeapSize) {
		this.initHeapSize = initHeapSize;
	}

	public int getMaxHeapSize() {
		return maxHeapSize;
	}

	public void setMaxHeapSize(int maxHeapSize) {
		this.maxHeapSize = maxHeapSize;
	}

	public String getLogFileLocation() {
		return logFileLocation;
	}

	public void setLogFileLocation(String logFileLocation) {
		this.logFileLocation = logFileLocation;
	}

	public boolean isEnableJVMLogRedirection() {
		return enableJVMLogRedirection;
	}

	public void setEnableJVMLogRedirection(boolean enableJVMLogRedirection) {
		this.enableJVMLogRedirection = enableJVMLogRedirection;
	}

	public String getArguments() {
		return arguments;
	}

	public void setArguments(String arguments) {
		this.arguments = arguments;
	}

}
